/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.doipMessage;

import com.google.gson.JsonElement;
import org.bdware.doip.codec.digitalObject.DigitalObject;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;

public class DoipMessageFactory {
    public static DoipMessage createTimeoutResponse(int requestID, String msg) {
        DoipMessage ret = new DoipMessage(null, null);
        ret.header.IsRequest = true;
        ret.header.parameters.response = DoipResponseCode.UnKnownError;
        ret.header.parameters.addAttribute("timeout", "timeout");
        ret.header.parameters.addAttribute("msg", msg);
        ret.requestID = requestID;
        return ret;
    }

    public static boolean isLocalTimeoutMessage(DoipMessage msg) {
        if (msg == null || msg.header == null || msg.header.parameters == null || msg.header.parameters.response == null) {
            return false;
        }
        if (msg.header.parameters.attributes == null) {
            return false;
        }
        if (!msg.header.parameters.attributes.has("timeout")) {
            return false;
        }
        return msg.header.parameters.response == DoipResponseCode.UnKnownError && msg.header.parameters.attributes.get("timeout").getAsString().equals("timeout");
    }

    public static DoipMessage createConnectFailedResponse(int requestID) {
        DoipMessage ret = new DoipMessage(null, null);
        ret.header.IsRequest = true;
        ret.header.parameters.response = DoipResponseCode.UnKnownError;
        ret.header.parameters.addAttribute("failed", "connect target doip service failed");
        ret.requestID = requestID;
        return ret;
    }

    public static class DoipMessageBuilder {
        DoipMessage ret;

        public DoipMessageBuilder createRequest(String targetID, String operation) {
            this.ret = new DoipMessage(targetID, operation);
            this.ret.header.setIsRequest(true);
            return this;
        }

        public DoipMessageBuilder createResponse(DoipResponseCode responseCode, DoipMessage reqMsg) {
            if (reqMsg == null) {
                this.ret = new DoipMessage(null, null, 0);
                this.ret.header.parameters.response = responseCode;
                return this;
            }
            this.ret = new DoipMessage(reqMsg.header.parameters.id, reqMsg.header.parameters.operation);
            this.ret.header.setIsRequest(false);
            this.ret.header.parameters = reqMsg.header.parameters.deepCopy();
            this.ret.header.parameters.response = responseCode;
            this.ret.requestID = reqMsg.requestID;
            this.ret.header.setIsCertified(reqMsg.header.isCertified());
            this.ret.header.setIsEncrypted(reqMsg.header.isEncrypted());
            if (reqMsg.credential != null && reqMsg.credential.getSigner() != null) {
                this.ret.setRecipientID(reqMsg.credential.getSigner());
            }
            return this;
        }

        public DoipMessageBuilder addAttributes(String key, JsonElement value) {
            this.ret.header.parameters.addAttribute(key, value);
            return this;
        }

        public DoipMessageBuilder addAttributes(String key, long value) {
            this.ret.header.parameters.addAttribute(key, value);
            return this;
        }

        public DoipMessageBuilder addAttributes(String key, String value) {
            this.ret.header.parameters.addAttribute(key, value);
            return this;
        }

        public DoipMessageBuilder addAttributes(String key, int value) {
            this.ret.header.parameters.addAttribute(key, value);
            return this;
        }

        public DoipMessageBuilder addAttributes(String key, boolean value) {
            this.ret.header.parameters.addAttribute(key, value);
            return this;
        }

        public DoipMessageBuilder setBody(byte[] body) {
            this.ret.body.encodedData = body;
            this.ret.header.bodyLength = this.ret.body.getLength();
            return this;
        }

        public DoipMessageBuilder setBody(DigitalObject digitalObject) {
            this.ret.body.setDataAsDigitalObject(digitalObject);
            return this;
        }

        public DoipMessage create() {
            return this.ret;
        }

        public DoipMessageBuilder setRequestID(int requestID) {
            this.ret.requestID = requestID;
            return this;
        }

        public DoipMessageBuilder setFlag(int flag) {
            this.ret.header.setFlag(flag);
            return this;
        }

        public DoipMessageBuilder setIsCertified(boolean isCertified) {
            this.ret.header.setIsCertified(isCertified);
            return this;
        }

        public DoipMessageBuilder setIsPragmatics(boolean isPragmatics) {
            this.ret.header.setIsPragmatics(isPragmatics);
            return this;
        }

        public DoipMessageBuilder setIsCommand(boolean isCommand) {
            this.ret.header.setIsCommand(isCommand);
            return this;
        }

        public DoipMessageBuilder setIsEncrypted(boolean isEncrypted) {
            this.ret.header.setIsEncrypted(isEncrypted);
            return this;
        }

        public DoipMessageBuilder setDoipMessage(DoipMessage message) {
            this.ret = message;
            return this;
        }
    }
}

