/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.v3;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.bdware.doip.codec.v3.ExtensionPartFactory;
import org.bdware.doip.codec.v3.headers.ExtensionPart;

public class DOIPV3Message {
    public byte majorVersion = (byte)3;
    public byte minorVersion = 0;
    public int nextHeader;
    public long requestID;
    public short reservedFlags;
    public int reserved1;
    public int contentLength;
    public static int HeaderLength = 24;
    public transient List<ExtensionPart> extensionParts;

    public void writeTo(ByteBuf bf) {
        this.fixNextHeaderAndCalculateContentLength();
        bf.writeByte((int)this.majorVersion);
        bf.writeByte((int)this.minorVersion);
        bf.writeInt(this.nextHeader);
        bf.writeLong(this.requestID);
        bf.writeShort((int)this.reservedFlags);
        bf.writeInt(this.reserved1);
        bf.writeInt(this.contentLength);
        if (this.extensionParts != null) {
            for (ExtensionPart part : this.extensionParts) {
                part.writeTo(bf);
            }
        }
    }

    public void fixNextHeaderAndCalculateContentLength() {
        this.contentLength = 0;
        if (this.extensionParts.size() > 0) {
            ExtensionPart previous = null;
            for (ExtensionPart part : this.extensionParts) {
                this.contentLength += part.length();
                if (previous == null) {
                    this.nextHeader = part.getType();
                } else {
                    previous.setNextType(part.getType());
                }
                previous = part;
            }
        }
    }

    public void readFrom(ByteBuf bf) {
        this.majorVersion = bf.readByte();
        this.minorVersion = bf.readByte();
        this.nextHeader = bf.readInt();
        this.requestID = bf.readLong();
        this.reservedFlags = bf.readShort();
        this.reserved1 = bf.readInt();
        this.contentLength = bf.readInt();
        this.extensionParts = new ArrayList<ExtensionPart>();
        this.parseRecursive(this.nextHeader, bf);
    }

    private void parseRecursive(int nextHeaderType, ByteBuf bf) {
        while (nextHeaderType != 0) {
            ExtensionPart part = ExtensionPartFactory.parse(nextHeaderType, bf);
            this.extensionParts.add(part);
            nextHeaderType = part.nextType;
        }
    }

    public void appendPart(ExtensionPart part) {
        if (this.extensionParts == null) {
            this.extensionParts = new ArrayList<ExtensionPart>();
        }
        this.extensionParts.add(part);
    }

    public String prettyPrint() {
        StringBuilder parts = new StringBuilder();
        if (this.extensionParts != null) {
            for (ExtensionPart part : this.extensionParts) {
                parts.append(part.prettyPrint()).append(" ");
            }
        }
        return String.format("major.minor:%d.%d %d %s", this.majorVersion, (int)this.minorVersion, this.contentLength, parts.toString());
    }

    public <T extends ExtensionPart> List<T> getPart(Class<T> type) {
        ArrayList<ExtensionPart> ret = new ArrayList<ExtensionPart>();
        if (this.extensionParts != null) {
            for (ExtensionPart part : this.extensionParts) {
                if (!type.isAssignableFrom(part.getClass())) continue;
                ret.add(part);
            }
        }
        return ret;
    }
}

