/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.v3.headers;

import io.netty.buffer.ByteBuf;
import org.bdware.doip.codec.v3.headers.ExtensionPart;

public class VDNHeader
extends ExtensionPart {
    public static final int EXTENSION_CODE = 3;
    public byte locateFlag;
    public long sourceId;
    public long destinationId;
    public static final int LENGTH = 21;

    public VDNHeader(ByteBuf bf) {
        this.nextType = bf.readInt();
        this.locateFlag = bf.readByte();
        this.sourceId = bf.readLong();
        this.destinationId = bf.readLong();
    }

    public VDNHeader() {
        this.locateFlag = 0;
        this.nextType = 0;
        this.destinationId = 0L;
        this.sourceId = 0L;
    }

    @Override
    public void writeTo(ByteBuf bf) {
        bf.writeInt(this.nextType);
        bf.writeByte((int)this.locateFlag);
        bf.writeLong(this.sourceId);
        bf.writeLong(this.destinationId);
    }

    @Override
    public int length() {
        return 21;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public String prettyPrint() {
        return "VDNHeader locateFlag:" + this.locateFlag + " " + this.sourceId + " " + this.destinationId;
    }
}

