/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.endpoint.client.DoipClientChannel;
import org.bdware.doip.endpoint.client.DoipMessageCallback;
import org.bdware.doip.endpoint.client.NettyDoipClientHandler;

public abstract class NettyDoipClientChannel
implements DoipClientChannel {
    static Logger logger = LogManager.getLogger(NettyDoipClientChannel.class);
    protected NettyDoipClientHandler handler;
    protected InetSocketAddress remoteAddress;
    protected boolean isConnected = false;
    protected Channel channel;
    protected long timeoutMillisecond = 5000L;

    @Override
    public void sendMessage(DoipMessage message, DoipMessageCallback cb, long timeout) {
        if (this.handler == null) {
            logger.error("client handler not set yet");
            return;
        }
        if (!this.isConnected) {
            logger.error("client not connected, connect first!");
        }
        logger.debug("channel send message");
        this.handler.sendMessage(message, cb, timeout);
    }

    @Override
    public void sendMessage(DoipMessage message, DoipMessageCallback cb) {
        this.sendMessage(message, cb, this.timeoutMillisecond);
    }

    @Override
    public abstract void connect(String var1) throws URISyntaxException, InterruptedException;

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isOpen() && this.channel.isActive();
    }

    @Override
    public void setTimeoutSecond(int ts) {
        this.timeoutMillisecond = ts * 1000;
    }
}

