/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.net.URISyntaxException;
import org.bdware.doip.codec.MessageEnvelopeCodec;
import org.bdware.doip.codec.NaiveEnvelopeToDoMessage;
import org.bdware.doip.codec.WebSocketFrameToByteBufCodec;
import org.bdware.doip.endpoint.client.NettyDoipClientChannel;
import org.bdware.doip.endpoint.client.NettyDoipClientHandler;

public class NettyDoipWSClientChannel
extends NettyDoipClientChannel {
    final Bootstrap b = new Bootstrap();
    static EventLoopGroup group;

    @Override
    public void close() {
        if (this.handler != null) {
            this.handler.close();
        }
        this.isConnected = false;
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException, InterruptedException {
        final URI uri = new URI(targetUrl);
        logger.debug("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort());
        if (group == null) {
            group = new NioEventLoopGroup();
        }
        this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
        this.b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x100000, 0x1400000));
        this.b.group(group);
        this.handler = new NettyDoipClientHandler();
        ((Bootstrap)((Bootstrap)this.b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                WebSocketClientProtocolHandler wsClientHandler = new WebSocketClientProtocolHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders()));
                p.addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)}).addLast(new ChannelHandler[]{wsClientHandler}).addLast(new ChannelHandler[]{new WebSocketFrameToByteBufCodec()}).addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(65536, 20, 4, 0, 0)}).addLast(new ChannelHandler[]{new MessageEnvelopeCodec()}).addLast(new ChannelHandler[]{new NaiveEnvelopeToDoMessage()}).addLast(new ChannelHandler[]{NettyDoipWSClientChannel.this.handler});
            }
        });
        logger.info("[DoipClient] Create TCP Client!");
        logger.debug("[URI Parse]host: " + uri.getHost() + "  port: " + uri.getPort());
        this.channel = this.b.connect(uri.getHost(), uri.getPort()).sync().channel();
        this.handler.setChannel(this.channel);
        this.isConnected = true;
    }
}

