/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server.v3;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.v3.DOIPV3Message;
import org.bdware.doip.codec.v3.V3MsgFactory;
import org.bdware.doip.endpoint.client.v3.MessageCallback;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.v3.RequestHandler;

@ChannelHandler.Sharable
public class ServerHandler
extends SimpleChannelInboundHandler<DOIPV3Message> {
    static Logger logger = LogManager.getLogger(ServerHandler.class);
    protected RequestHandler requestHandler;
    V3MsgFactory factory = new V3MsgFactory();

    public ServerHandler(RequestHandler handler, DoipListenerConfig listenerConfig) {
        this.requestHandler = handler;
    }

    protected void channelRead0(final ChannelHandlerContext ctx, final DOIPV3Message msg) {
        if (msg.requestID == 0L) {
            this.replyErrorString(ctx, msg, "invalid requestID");
            return;
        }
        this.requestHandler.handle(ctx, msg, new MessageCallback<DOIPV3Message>(){

            @Override
            public void onResult(DOIPV3Message result) {
                assert (result.requestID == msg.requestID);
                ctx.writeAndFlush((Object)result);
            }
        });
    }

    public void channelActive(ChannelHandlerContext ctx) {
    }

    public void defaultHandler(ChannelHandlerContext ctx, DOIPV3Message request) {
        this.replyErrorString(ctx, request, "Unsupported Operation!");
    }

    protected void replyErrorString(ChannelHandlerContext ctx, DOIPV3Message request, String str) {
        this.sendResponse(ctx, this.factory.createErrorMessage(request.requestID, str));
    }

    private void sendResponse(ChannelHandlerContext ctx, DOIPV3Message response) {
        ctx.writeAndFlush((Object)response);
    }
}

