/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server.v3;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.v3.DOIPCodec;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.v3.RequestHandler;
import org.bdware.doip.endpoint.server.v3.ServerHandler;

public class TCPListener {
    private final int port;
    static Logger logger = LogManager.getLogger(TCPListener.class);
    private final DoipListenerConfig listenerConfig;
    private Channel ch;
    private ServerHandler handler;

    public TCPListener(int port, DoipListenerConfig listenerConfig) {
        this.port = port;
        this.listenerConfig = listenerConfig;
    }

    public void setRequestHandler(RequestHandler handler) {
        this.handler = new ServerHandler(handler, this.listenerConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.handler == null) {
            logger.error("Handler not init yet! set handler first");
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        final int maxFrame = 0x500000;
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(2 * maxFrame, 10 * maxFrame));
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.port);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipline = ch.pipeline();
                    pipline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrame, 20, 4, 0, 0)}).addLast(new ChannelHandler[]{new DOIPCodec()});
                    pipline.addLast(new ChannelHandler[]{TCPListener.this.handler});
                }
            });
            this.ch = b.bind().syncUninterruptibly().channel();
            logger.info("TCP DOIP V3 listener start at:" + this.port);
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
        }
    }

    public void stop() {
        this.ch.close();
    }
}

