package org.bdware.doip.codec.v3.headers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;

public class DOLHeader extends ExtensionPart {
    public static final int EXTENSION_CODE = 1;
    //locateFlag=0 需要交换机定位，向其他交换机转发。
    //locateFlag=1 表示就是这个交换机了，需要交换机向空间转发。
    private int dolLength;
    private byte[] dol;

    public DOLHeader(ByteBuf bf) {
        super();
        nextType = bf.readInt();
        dolLength = bf.readInt();
        if (dolLength > 0) {
            dol = new byte[dolLength];
            bf.readBytes(dol);
        }
    }

    public DOLHeader() {

    }

    public void setDOL(byte[] newDol) {
        if (newDol == null) dolLength = 0;
        else {
            this.dol = newDol;
            this.dolLength = dol.length;
        }
    }

    @Override
    public void writeTo(ByteBuf bf) {
        //keep the correctness of nextType
        bf.writeInt(nextType);
        if (dol != null && dol.length > 0) {
            bf.writeInt(dol.length);
            bf.writeBytes(dol);
        } else bf.writeInt(0);
    }

    @Override
    public int length() {
        return 8 + ((dol == null) ? 0 : dol.length);
    }

    @Override
    public int getType() {
        return EXTENSION_CODE;
    }

    @Override
    public String prettyPrint() {
        return "DOLHeader dol:" + ByteBufUtil.hexDump(dol);
    }

    public byte[] getDol() {
        return dol;
    }
}
