/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.client;

import com.nimbusds.jose.jwk.JWK;
import org.apache.log4j.Logger;
import org.bdware.irp.client.CdiIrpClient;
import org.bdware.irp.client.GeneralIrpClient;
import org.bdware.irp.client.InternalIrpClient;
import org.bdware.irp.client.IrpClient;
import org.bdware.irp.client.IrpClientImpl;
import org.bdware.irp.exception.IrpClientException;

public class GlobalIrpClient {
    static Logger logger = Logger.getLogger(GlobalIrpClient.class);
    public static IrpClient globalIrpClient;

    public static IrpClient getGlobalClient() throws IrpClientException {
        if (globalIrpClient == null) {
            logger.error((Object)"globalIrpClient not initialized yet! ");
            throw new IrpClientException("globalIrpClient not initialized yet!");
        }
        return globalIrpClient;
    }

    public static void useTcpIrpClient(JWK kp, String clientID, String LHSUrl) {
        globalIrpClient = new IrpClientImpl(kp, clientID, LHSUrl);
    }

    public static void useCdiIrpClient(JWK kp, String clientID, String LHSUrl) {
        globalIrpClient = new CdiIrpClient(kp, clientID, LHSUrl);
    }

    public static void useGeneralIrpClient(JWK kp, String clientID, String LHSUrl) {
        globalIrpClient = new GeneralIrpClient(kp, clientID, LHSUrl);
    }

    public static void useInternalIrpClient(JWK kp, String clientID, String LHSUrl) {
        globalIrpClient = new InternalIrpClient(kp, clientID, LHSUrl);
    }
}

