/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpclient;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.bdware.irp.irpclient.IrpClientChannel;
import org.bdware.irp.irpclient.IrpMessageCallback;
import org.bdware.irp.irpclient.NettyIrpClientHandler;
import org.bdware.irp.irpclient.NettyIrpTCPClientChannel;
import org.bdware.irp.irplib.core.IrpMessage;

public abstract class NettyIrpClientChannel
implements IrpClientChannel {
    static Logger logger = Logger.getLogger(NettyIrpClientChannel.class);
    NettyIrpClientHandler handler;
    InetSocketAddress remoteAddress;
    boolean isConnected = false;
    Channel channel;

    public static IrpClientChannel createByServerUrl(String url) {
        try {
            URI uri = new URI(url);
            logger.debug((Object)("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort()));
            switch (uri.getScheme()) {
                case "udp": 
                case "UDP": 
                case "tcp": 
                case "TCP": {
                    return new NettyIrpTCPClientChannel();
                }
            }
            logger.error((Object)"unsupported transfer scheme");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void sendMessage(IrpMessage message, IrpMessageCallback cb) {
        if (this.handler == null) {
            logger.error((Object)"client handler not set yet");
            return;
        }
        if (!this.isConnected) {
            logger.error((Object)"client not connected, connect first!");
        }
        logger.debug((Object)"channel send message");
        this.handler.sendMessage(message, cb);
    }

    @Override
    public abstract void connect(String var1) throws URISyntaxException;

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }
}

