/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpclient;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.bdware.irp.irpclient.NettyIrpClientChannel;
import org.bdware.irp.irpclient.NettyIrpClientHandler;
import org.bdware.irp.irplib.crypto.NettyTCPCodeC;

public class NettyIrpTCPClientChannel
extends NettyIrpClientChannel {
    static Logger logger = Logger.getLogger(NettyIrpTCPClientChannel.class);
    final Bootstrap b = new Bootstrap();
    static EventLoopGroup group = new NioEventLoopGroup();

    public NettyIrpTCPClientChannel() {
        this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
        this.b.group(group);
        this.handler = new NettyIrpClientHandler();
        ((Bootstrap)((Bootstrap)this.b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(262144, 16, 4, 0, 0)}).addLast(new ChannelHandler[]{new NettyTCPCodeC()}).addLast(new ChannelHandler[]{NettyIrpTCPClientChannel.this.handler});
            }
        });
    }

    @Override
    public void close() {
        if (this.handler != null) {
            this.handler.close();
        }
        this.isConnected = false;
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException {
        URI uri = new URI(targetUrl);
        logger.debug((Object)("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort()));
        try {
            this.channel = this.b.connect(uri.getHost(), uri.getPort()).sync().channel();
            this.handler.setChannel(this.channel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isConnected = true;
    }
}

