/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpserver;

import com.google.gson.Gson;
import org.apache.log4j.Logger;
import org.bdware.irp.irpserver.IrpListener;
import org.bdware.irp.irpserver.IrpListenerInfo;
import org.bdware.irp.irpserver.IrpRequestHandler;
import org.bdware.irp.irpserver.NettyIrpListenerTCP;
import org.bdware.irp.irpserver.NettyServerHandler;

public abstract class NettyIrpListener
implements IrpListener {
    static Logger logger = Logger.getLogger(NettyIrpListener.class);
    NettyServerHandler handler;

    public static NettyIrpListener CreateIrpListener(IrpListenerInfo listenerInfo) {
        try {
            switch (listenerInfo.protocolType) {
                case "TCP": {
                    return new NettyIrpListenerTCP(listenerInfo);
                }
            }
            logger.error((Object)("[Create irp server error] Unsupported Listener: " + new Gson().toJson((Object)listenerInfo)));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setRequestHandler(IrpRequestHandler handler) {
        this.handler = new NettyServerHandler(handler);
    }

    @Override
    public abstract void start();

    @Override
    public abstract void stop();
}

