/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.nimbusds.jose.jwk.JWK;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.bdware.irp.client.IrpClient;
import org.bdware.irp.crypto.CertUtils;
import org.bdware.irp.exception.IrpClientException;
import org.bdware.irp.stateinfo.DoStateInfo;
import org.bdware.irp.stateinfo.StateInfoBase;

public class CdiIrpClient
implements IrpClient {
    JWK clientKeyPair;
    String LHSUrl;
    static Logger logger = Logger.getLogger(CdiIrpClient.class);
    String ClientID;

    public CdiIrpClient(JWK kp, String clientID, String LHSUrl) {
        this.ClientID = clientID;
        this.LHSUrl = LHSUrl;
    }

    @Override
    public StateInfoBase resolve(String handle) throws IrpClientException {
        String response = this.resolveFromLHS(handle);
        JsonObject resp = (JsonObject)new Gson().fromJson(response, JsonObject.class);
        StateInfoBase hr = new StateInfoBase();
        if (resp == null || !resp.has("identifier") || resp.has("status")) {
            throw new IrpClientException(response);
        }
        hr.identifier = resp.get("identifier").getAsString();
        hr.handleValues = resp;
        return hr;
    }

    @Override
    public String register(StateInfoBase hr) throws IrpClientException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String keys : hr.handleValues.keySet()) {
            map.put(keys, hr.handleValues.get(keys).getAsString());
        }
        map.remove("identifier");
        map.put("action", "forceRegister");
        String response = this.signAndSend(hr, map);
        JsonObject resp = (JsonObject)new Gson().fromJson(response, JsonObject.class);
        if (resp == null || !resp.has("identifier")) {
            throw new IrpClientException(response);
        }
        return resp.get("identifier").getAsString();
    }

    @Override
    public String reRegister(StateInfoBase hr) throws IrpClientException {
        if (hr.identifier == null) {
            logger.warn((Object)"handle need to be set.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String keys : hr.handleValues.keySet()) {
            map.put(keys, hr.handleValues.get(keys).getAsString());
        }
        map.put("identifier", hr.identifier);
        map.put("action", "forceRegister");
        String response = this.signAndSend(hr, map);
        JsonObject resp = (JsonObject)new Gson().fromJson(response, JsonObject.class);
        if (resp == null || !resp.has("identifier")) {
            throw new IrpClientException(response);
        }
        return resp.get("identifier").getAsString();
    }

    @Override
    public String unRegister(String handle) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("identifier", handle);
        map.put("action", "forceDelete");
        DoStateInfo hr = new DoStateInfo("", "");
        hr.identifier = handle;
        return this.signAndSend(hr, map);
    }

    @Override
    public List<String> batchRegister(StateInfoBase hr, int count) {
        return null;
    }

    private String signAndSend(StateInfoBase hr, Map<String, String> map) {
        map.put("dou", this.ClientID);
        String reqMapStr = this.MapToString(map);
        if (this.clientKeyPair != null) {
            try {
                String signature = CertUtils.Sign(reqMapStr.getBytes(), this.clientKeyPair);
                map.put("signature", signature);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.sendPost(map, this.LHSUrl + this.getSubUrl(hr));
    }

    public String MapToString(Map<String, String> reqMap) {
        Set<String> keySet = reqMap.keySet();
        keySet.remove("signature");
        TreeSet<String> sortSet = new TreeSet<String>();
        sortSet.addAll(keySet);
        String mapString = "";
        for (String key : sortSet) {
            if (reqMap.get(key) == null) continue;
            mapString = mapString + reqMap.get(key);
        }
        return mapString;
    }

    public String resolveFromLHS(String id) {
        String result;
        String resolveUrl = this.LHSUrl + "resolve?identifier=" + id;
        HttpGet httpGet = new HttpGet(resolveUrl);
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            InputStream in = response.getEntity().getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuilder strber = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                strber.append(line + '\n');
            }
            br.close();
            in.close();
            result = strber.toString();
            if (response.getStatusLine().getStatusCode() != 200) {
                result = "\u670d\u52a1\u5668\u5f02\u5e38";
            }
        }
        catch (Exception e) {
            System.out.println("\u8bf7\u6c42\u5f02\u5e38");
            throw new RuntimeException(e);
        }
        return result;
    }

    public String sendPost(Map<String, String> reqMap, String url) {
        String result;
        HttpPost post = new HttpPost(url);
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (String keys : reqMap.keySet()) {
                params.add(new BasicNameValuePair(keys, reqMap.get(keys)));
            }
            UrlEncodedFormEntity postForm = new UrlEncodedFormEntity(params, "utf-8");
            post.setEntity((HttpEntity)postForm);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            InputStream in = response.getEntity().getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            StringBuilder strber = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                strber.append(line + '\n');
            }
            br.close();
            in.close();
            result = strber.toString();
            if (response.getStatusLine().getStatusCode() != 200) {
                result = "\u670d\u52a1\u5668\u5f02\u5e38";
            }
        }
        catch (Exception e) {
            System.out.println("\u8bf7\u6c42\u5f02\u5e38");
            throw new RuntimeException(e);
        }
        finally {
            post.abort();
        }
        return result;
    }

    private String getSubUrl(StateInfoBase hr) {
        String subUrl;
        String className;
        switch (className = hr.getClass().getSimpleName()) {
            case "DoHandleRecord": {
                subUrl = "do/";
                break;
            }
            case "DoipServiceHandleRecord": {
                subUrl = "service/";
                break;
            }
            case "UserHandleRecord": {
                subUrl = "dou/";
                break;
            }
            default: {
                logger.error((Object)"use specific handle record class instead.");
                subUrl = "";
            }
        }
        return subUrl;
    }
}

