/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nimbusds.jose.jwk.JWK;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.irp.client.IrpClient;
import org.bdware.irp.client.IrsClient;
import org.bdware.irp.exception.IrpClientException;
import org.bdware.irp.irpclient.IrpClientChannel;
import org.bdware.irp.irpclient.IrpClientChannelGenerator;
import org.bdware.irp.irpclient.IrpMessageCallback;
import org.bdware.irp.irplib.core.HandleRequest;
import org.bdware.irp.irplib.core.HandleResponse;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpRequest;
import org.bdware.irp.irplib.core.IrpResponse;
import org.bdware.irp.irplib.exception.IrpConnectException;
import org.bdware.irp.stateinfo.StateInfoBase;

public class IrpClientImpl
implements IrpClient,
IrsClient {
    static Logger LOGGER = Logger.getLogger(IrpClientImpl.class);
    IrpClientChannel irpChannel;
    String serverURL = null;
    ResponseCallback rcb;
    ResponseContainer container;
    String ClientID;
    JWK clientKeyPair;
    String address = null;

    public IrpClientImpl(JWK kp, String clientID, String LHSUrl) {
        this.clientKeyPair = kp;
        this.ClientID = clientID;
        this.serverURL = LHSUrl;
        this.container = new ResponseContainer();
        this.rcb = new ResponseCallback(this.container);
    }

    public String resolveHandle(String handle) throws IrpClientException {
        HandleRequest req = HandleRequest.newResolveHandleRequest(handle, null, null);
        this.sendMessage(req, this.rcb);
        HandleResponse res = (HandleResponse)this.waitForResponse();
        JsonArray values = JsonParser.parseString((String)res.getHandleValuesAsJson()).getAsJsonArray();
        JsonObject result = new JsonObject();
        result.addProperty("handle", res.getHandle());
        result.add("values", (JsonElement)values);
        return result.toString();
    }

    public IrpResponse sendMessageSync(IrpMessage irpMessage) {
        this.sendMessage(irpMessage, this.rcb);
        return this.waitForResponse();
    }

    @Override
    public StateInfoBase resolve(String doid) throws IrpClientException {
        IrpRequest req = IrpRequest.newIrsResolveRequest(doid, null);
        this.sendMessage(req, this.rcb);
        IrpResponse res = this.waitForResponse();
        LOGGER.info((Object)res.toString());
        if (res.result == "success") {
            String values = new Gson().toJson(res.getDoidValuesByMap());
            JsonObject resp = JsonParser.parseString((String)values).getAsJsonObject();
            StateInfoBase hr = new StateInfoBase();
            if (resp == null) {
                throw new IrpClientException("resolve failed!");
            }
            hr.identifier = res.getDoid();
            hr.handleValues = resp;
            return hr;
        }
        return null;
    }

    @Override
    public String register(StateInfoBase hr) throws IrpClientException {
        HashMap<String, String> map = this.hrToMap(hr);
        map.remove("identifier");
        IrpRequest req = IrpRequest.newIrsCreateDoidRequest(map, this.clientKeyPair);
        this.sendMessage(req, this.rcb);
        IrpResponse res = this.waitForResponse();
        if (res.result != "success") {
            LOGGER.error((Object)("Register doid failed: " + res.getResponseMessage()));
            throw new IrpClientException("register failed!");
        }
        return res.getDoid();
    }

    @Override
    public String reRegister(StateInfoBase hr) throws IrpClientException {
        if (hr.identifier == null) {
            LOGGER.warn((Object)"handle need to be set.");
        }
        HashMap<String, String> map = this.hrToMap(hr);
        IrpRequest req = IrpRequest.newIrsUpdateDoidRequest(hr.identifier, map, this.clientKeyPair);
        this.sendMessage(req, this.rcb);
        IrpResponse res = this.waitForResponse();
        if (res.result != "success") {
            LOGGER.error((Object)("Reregister doid failed: " + res.getResponseMessage()));
            throw new IrpClientException("reregister failed!");
        }
        return res.getDoid();
    }

    @Override
    public String unRegister(String handle) {
        if (handle == null) {
            LOGGER.warn((Object)"handle need to be set.");
        }
        IrpRequest req = IrpRequest.newIrsDeleteDoidRequest(handle, this.clientKeyPair);
        this.sendMessage(req, this.rcb);
        IrpResponse res = this.waitForResponse();
        if (res.result != "success") {
            LOGGER.error((Object)("Delete doid failed: " + res.getResponseMessage()));
        }
        return res.result;
    }

    @Override
    public List<String> batchRegister(StateInfoBase hr, int count) throws IrpClientException {
        HashMap<String, String> map = this.hrToMap(hr);
        map.remove("identifier");
        IrpRequest req = IrpRequest.newIrsBatchCreateDoidRequest(map, count, this.clientKeyPair);
        this.sendMessage(req, this.rcb);
        IrpResponse res = this.waitForResponse();
        if (res.result != "success") {
            LOGGER.error((Object)("Register doid failed: " + res.getResponseMessage()));
            throw new IrpClientException("register failed!");
        }
        return res.getDoidList();
    }

    @Override
    public boolean verifyIrsServer() {
        if (this.clientKeyPair.getKeyID() == null) {
            LOGGER.warn((Object)"pre_doid need to be set in the jwk sk string to verify the irs server!");
            return false;
        }
        IrpRequest req = IrpRequest.newVerityIrsServerRequest(this.clientKeyPair, this.address);
        this.sendMessage(req, this.rcb);
        IrpResponse res = this.waitForResponse();
        if (res.result != "success") {
            LOGGER.error((Object)("Verify the IRS Server from GRS failed: " + res.getResponseMessage()));
            return false;
        }
        return true;
    }

    @Override
    public StateInfoBase resolvePrefix(String doid) throws IrpClientException {
        IrpRequest req = IrpRequest.newGrsResolveRequest(doid, null);
        this.sendMessage(req, this.rcb);
        IrpResponse res = this.waitForResponse();
        LOGGER.info((Object)res.toString());
        if (res.result == "success") {
            String values = new Gson().toJson(res.getDoidValuesByMap());
            JsonObject resp = JsonParser.parseString((String)values).getAsJsonObject();
            StateInfoBase hr = new StateInfoBase();
            if (resp == null) {
                throw new IrpClientException("resolve failed!");
            }
            hr.identifier = res.getDoid();
            hr.handleValues = resp;
            return hr;
        }
        return null;
    }

    @Override
    public boolean syncPrefixToGrs(StateInfoBase stateInfoBase) throws IrpClientException {
        LOGGER.info((Object)new Gson().toJson((Object)stateInfoBase));
        IrpRequest req = IrpRequest.newGrsCreateOrgRequest(stateInfoBase.getIdentifier(), this.hrToMap(stateInfoBase), null);
        this.sendMessage(req, this.rcb);
        IrpResponse res = this.waitForResponse();
        LOGGER.info((Object)res.toString());
        return res.result == "success";
    }

    @Override
    public boolean synPrefixToParent(StateInfoBase stateInfoBase) throws IrpClientException {
        return false;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    private HashMap<String, String> hrToMap(StateInfoBase handleRecord) {
        String className;
        HashMap<String, String> hrMap = new HashMap<String, String>();
        for (String keys : handleRecord.handleValues.keySet()) {
            LOGGER.info((Object)keys);
            if (handleRecord.handleValues.get(keys) == null || handleRecord.handleValues.get(keys).isJsonNull()) continue;
            hrMap.put(keys, handleRecord.handleValues.get(keys).getAsString());
        }
        switch (className = handleRecord.getClass().getSimpleName()) {
            case "DoStateInfo": {
                hrMap.put("hrType", "do");
                break;
            }
            case "DoipServiceStateInfo": {
                hrMap.put("hrType", "org/bdware/doip");
                break;
            }
            case "UserStateInfo": {
                hrMap.put("hrType", "dou");
                break;
            }
            default: {
                LOGGER.error((Object)"use specific handle record class instead.");
            }
        }
        return hrMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IrpResponse waitForResponse() {
        this.container.response = null;
        ResponseCallback responseCallback = this.rcb;
        synchronized (responseCallback) {
            try {
                this.rcb.wait(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.container.response == null) {
            this.container.response = IrpResponse.newErrorResponse(0, 2, "Server response timeout!");
        }
        return this.container.response;
    }

    public void close() {
        this.irpChannel.close();
        this.irpChannel = null;
    }

    public void connect(String url) {
        try {
            this.irpChannel = IrpClientChannelGenerator.createIrpClientChannel(url);
            if (this.irpChannel == null) {
                return;
            }
            this.irpChannel.connect(url);
            this.serverURL = url;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void reconnect() throws IrpConnectException {
        if (this.serverURL == null) {
            throw new IrpConnectException("target URL not set, use .connect(url) first");
        }
        if (this.irpChannel == null) {
            this.irpChannel = IrpClientChannelGenerator.createIrpClientChannel(this.serverURL);
        }
        if (this.irpChannel == null) {
            return;
        }
        try {
            this.irpChannel.connect(this.serverURL);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public boolean isConnected() {
        return this.irpChannel != null && this.irpChannel.isConnected();
    }

    public void sendMessage(IrpMessage msg, IrpMessageCallback cb) {
        this.connect(this.serverURL);
        if (this.irpChannel == null || !this.irpChannel.isConnected()) {
            LOGGER.warn((Object)"channel not connect yet!");
            return;
        }
        this.irpChannel.sendMessage(msg, cb);
    }

    static class ResponseContainer {
        IrpResponse response;

        ResponseContainer() {
        }
    }

    class ResponseCallback
    implements IrpMessageCallback {
        ResponseContainer responseContainer;

        public ResponseCallback(ResponseContainer container) {
            this.responseContainer = container;
        }

        @Override
        public synchronized void onResult(IrpMessage msg) {
            LOGGER.info((Object)("<callback>message header: " + msg.header.opCode));
            this.responseContainer.response = (IrpResponse)msg;
            this.notifyAll();
        }
    }
}

