/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.core;

import com.nimbusds.jose.jwk.JWK;
import java.security.Signature;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bdware.irp.irplib.core.IrpMessageBody;
import org.bdware.irp.irplib.core.IrpMessageCredential;
import org.bdware.irp.irplib.core.IrpMessageEnvelope;
import org.bdware.irp.irplib.core.IrpMessageHeader;
import org.bdware.irp.irplib.exception.IrpMessageDecodeException;
import org.bdware.irp.irplib.exception.IrpMessageEncodeException;
import org.bdware.irp.irplib.util.EncoderUtils;
import org.bdware.irp.irplib.util.GlobalUtils;
import org.bdware.irp.irplib.util.IrpCommon;

public abstract class IrpMessage {
    public byte[] encodedMessageBody = null;
    public byte[] encodedCredential = null;
    public byte[] encodedMessage = null;
    public long createTime;
    public IrpMessageEnvelope envelope;
    public IrpMessageHeader header;
    public IrpMessageBody body;
    public IrpMessageCredential credential;

    public IrpMessage(int opCode) {
        this.envelope = new IrpMessageEnvelope();
        this.header = new IrpMessageHeader(opCode);
        this.body = new IrpMessageBody();
        this.credential = new IrpMessageCredential();
        this.createTime = System.currentTimeMillis();
    }

    public IrpMessage(int opCode, int responseCode) {
        this.envelope = new IrpMessageEnvelope();
        this.header = new IrpMessageHeader(opCode, responseCode);
        this.body = new IrpMessageBody();
        this.credential = new IrpMessageCredential();
        this.createTime = System.currentTimeMillis();
    }

    public IrpMessage(int opCode, int responseCode, int requestId) {
        this.envelope = new IrpMessageEnvelope(requestId);
        this.header = new IrpMessageHeader(opCode, responseCode);
        this.body = new IrpMessageBody();
        this.credential = new IrpMessageCredential();
        this.createTime = System.currentTimeMillis();
    }

    public final void signMessage(Signature signer) {
        try {
            byte[] digestData = this.getEncodedMessageHeaderBody();
            signer.update(digestData);
            this.credential.signedInfoType = IrpCommon.CREDENTIAL_SIGNEDINFO_TYPE_RSA;
            this.credential.signedInfoDigestAlgorithm = GlobalUtils.getDigestAlgFromSignature(signer.getAlgorithm());
            this.credential.signature = signer.sign();
            this.encodedMessage = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void signMessage(JWK jwk) {
        try {
            byte[] digestData = this.getEncodedMessageHeaderBody();
            String signature = GlobalUtils.signByteArrayByJWK(digestData, jwk);
            this.credential.signerDoid = GlobalUtils.encodeString(jwk.getKeyID());
            this.credential.signedInfoType = IrpCommon.CREDENTIAL_SIGNEDINFO_TYPE_JWK;
            this.credential.signedInfoDigestAlgorithm = IrpCommon.CREDENTIAL_DIGEST_ALG_JWK;
            this.credential.signature = GlobalUtils.encodeString(signature);
            this.credential.signedInfoLength = this.credential.signedInfoDigestAlgorithm.length + this.credential.signature.length;
            this.encodedMessage = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final String getSignature() {
        if (this.credential.signature != null) {
            return GlobalUtils.decodeString(this.credential.signature);
        }
        return null;
    }

    public final byte[] getEncodedMessageHeaderBody() throws IrpMessageEncodeException {
        if (this.encodedMessageBody != null) {
            return this.encodedMessageBody;
        }
        this.encodedMessageBody = EncoderUtils.encodeMessageBody(this);
        return this.encodedMessageBody;
    }

    public final byte[] getEncodeMessageCredential() throws IrpMessageEncodeException {
        if (this.encodedCredential != null) {
            return this.encodedCredential;
        }
        if (this.header.getCertifiedFlag()) {
            this.encodedCredential = EncoderUtils.encodeMessageCredential(this.credential);
        } else {
            this.encodedCredential = new byte[4];
            EncoderUtils.writeIntToBuffer(0, this.encodedCredential, 0);
        }
        return this.encodedCredential;
    }

    public final byte[] getEncodedMessage() throws IrpMessageEncodeException {
        if (this.encodedMessage != null) {
            return this.encodedMessage;
        }
        this.getEncodedMessageHeaderBody();
        this.getEncodeMessageCredential();
        this.encodedMessage = new byte[this.encodedMessageBody.length + this.encodedCredential.length];
        System.arraycopy(this.encodedMessageBody, 0, this.encodedMessage, 0, this.encodedMessageBody.length);
        System.arraycopy(this.encodedCredential, 0, this.encodedMessage, this.encodedMessageBody.length, this.encodedCredential.length);
        return this.encodedMessage;
    }

    public static byte[][] fromMap2Byte(Map<String, String> hashMap) {
        byte[][] bytes = new byte[hashMap.size()][];
        int index = 0;
        for (String key : hashMap.keySet()) {
            byte[] keyCode = GlobalUtils.encodeString(key);
            byte[] valueCode = GlobalUtils.encodeString(hashMap.get(key));
            byte[] entryCode = new byte[4 + keyCode.length + 4 + valueCode.length];
            int offset = EncoderUtils.writeStringByteToBuffer(keyCode, entryCode, 0);
            EncoderUtils.writeStringByteToBuffer(valueCode, entryCode, offset);
            bytes[index] = entryCode;
            ++index;
        }
        return bytes;
    }

    public static Map<String, String> fromBytes2Map(byte[][] buf) throws IrpMessageDecodeException {
        HashMap<String, String> doidValue = new HashMap<String, String>();
        for (byte[] sigBuf : buf) {
            byte[] keyCode = EncoderUtils.readStringByteFromBuffer(sigBuf, 0);
            int offsetPos = 4 + keyCode.length;
            byte[] valueCode = EncoderUtils.readStringByteFromBuffer(sigBuf, offsetPos);
            doidValue.put(GlobalUtils.decodeString(keyCode), GlobalUtils.decodeString(valueCode));
        }
        return doidValue;
    }

    public String toString() {
        String str = "version=" + this.envelope.majorVersion + '.' + this.envelope.minVersion + "; opCode=" + this.header.opCode + "; responseCode=" + this.header.responseCode + "; opFlag" + this.header.getOpFlagByFlags() + "; bodyLength" + this.header.bodyLength + "; createTime:" + new Date(this.createTime);
        return str;
    }

    public abstract String getDoid();
}

