/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.crypto.AbstractPacketReceiveBuffer;
import org.bdware.irp.irplib.crypto.IrpMessagePacket;

public class NettyTCPCodeC
extends MessageToMessageCodec<ByteBuf, IrpMessage> {
    Logger logger = Logger.getLogger(NettyTCPCodeC.class);
    HashMap<Integer, AbstractPacketReceiveBuffer> receiveBufferMap = new HashMap();

    protected void encode(ChannelHandlerContext ctx, IrpMessage msg, List<Object> out) {
        try {
            ByteBuf buff = Unpooled.directBuffer();
            IrpMessagePacket messsagePacket = IrpMessagePacket.irpMessageToTCPPackets(msg);
            this.logger.debug((Object)("encoding IRP message to byteBuffer, msg opcode: " + msg.header.opCode + ", msg body length: " + messsagePacket.bodyPacket.length));
            buff.writeBytes(IrpMessagePacket.toBytes(messsagePacket));
            this.logger.debug((Object)("finish encoding, packet length: " + buff.readableBytes()));
            out.add(buff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        try {
            byte[] packetBytes = new byte[msg.readableBytes()];
            msg.readBytes(packetBytes);
            IrpMessagePacket packet = IrpMessagePacket.bytesToMessagePacket(packetBytes);
            out.add(IrpMessagePacket.packetTCPToIrpMessage(packet));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

