/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpserver;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.log4j.Logger;
import org.bdware.irp.irplib.crypto.NettyTCPCodeC;
import org.bdware.irp.irpserver.IrpListenerInfo;
import org.bdware.irp.irpserver.NettyIrpListener;

public class NettyIrpListenerTCP
extends NettyIrpListener {
    private final int port;
    static Logger logger = Logger.getLogger(NettyIrpListenerTCP.class);
    private Channel ch;

    protected NettyIrpListenerTCP(IrpListenerInfo listenerInfo) {
        this.port = listenerInfo.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.handler == null) {
            logger.error((Object)"Handler not init yet! set handler first");
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.port);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(262144, 16, 4, 0, 0)}).addLast(new ChannelHandler[]{new NettyTCPCodeC()}).addLast(new ChannelHandler[]{NettyIrpListenerTCP.this.handler});
                }
            });
            this.ch = b.bind().syncUninterruptibly().channel();
            logger.info((Object)("TCP DOIP listener start at:" + this.port));
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
        if (this.ch != null) {
            this.ch.close();
        }
    }
}

