/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.core;

import com.bdware.irp.util.GlobalUtils;
import java.util.Map;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpMessageSigner;
import org.bdware.irp.irplib.core.IrpRequest;

public class IrpRequestFactory {
    public static final String DOID_DEFAULT = "doidForCreate";
    public IrpMessageSigner singer;

    public IrpRequestFactory(IrpMessageSigner signer) {
        this.singer = signer;
    }

    public IrpRequest newIrsResolveRequest(String doid, String[] keys) {
        IrpRequest req = new IrpRequest(11, doid);
        if (keys != null) {
            req.requestedKeys = new byte[keys.length][];
            for (int i = 0; i < keys.length; ++i) {
                req.requestedKeys[i] = GlobalUtils.encodeString(keys[i]);
            }
        }
        return req;
    }

    public IrpRequest newGrsResolveRequest(String doid, String[] keys) {
        IrpRequest req = new IrpRequest(212, doid);
        if (keys != null) {
            req.requestedKeys = new byte[keys.length][];
            for (int i = 0; i < keys.length; ++i) {
                req.requestedKeys[i] = GlobalUtils.encodeString(keys[i]);
            }
        }
        return req;
    }

    public IrpRequest newGrsCreateOrgRequest(String doi, Map<String, String> values) {
        IrpRequest req = new IrpRequest(213, doi);
        if (values != null) {
            req.doidValues = IrpMessage.fromMap2Byte(values);
        }
        if (this.singer != null) {
            this.singer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsSynOrgToParentRequest(String doi, Map<String, String> values) {
        IrpRequest req = new IrpRequest(213, doi);
        if (values != null) {
            req.doidValues = IrpMessage.fromMap2Byte(values);
        }
        if (this.singer != null) {
            this.singer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsResolveRequest(byte[] doid, byte[][] keys) {
        IrpRequest req = new IrpRequest(11, doid);
        req.requestedKeys = keys;
        return req;
    }

    public IrpRequest newIrsCreateDoidRequest(Map<String, String> values) {
        IrpRequest req = new IrpRequest(110, DOID_DEFAULT);
        if (values != null) {
            req.doidValues = IrpMessage.fromMap2Byte(values);
        }
        if (this.singer != null) {
            this.singer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsCreateDoidRequest(byte[] doid, byte[][] values) {
        IrpRequest req = new IrpRequest(110, doid);
        req.doidValues = values;
        if (this.singer != null) {
            this.singer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsUpdateDoidRequest(String doid, Map<String, String> values) {
        IrpRequest req = new IrpRequest(117, doid);
        if (values != null) {
            req.doidValues = IrpMessage.fromMap2Byte(values);
        }
        if (this.singer != null) {
            this.singer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsUpdateDoidRequest(byte[] doid, byte[][] values) {
        IrpRequest req = new IrpRequest(117, doid);
        req.doidValues = values;
        return req;
    }

    public IrpRequest newIrsDeleteDoidRequest(String doid) {
        IrpRequest req = new IrpRequest(111, doid);
        if (this.singer != null) {
            this.singer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsDeleteDoidRequest(byte[] doid) {
        IrpRequest req = new IrpRequest(111, doid);
        return req;
    }

    public IrpRequest newIrsBatchCreateDoidRequest(Map<String, String> values, int count) {
        IrpRequest req = new IrpRequest(120, DOID_DEFAULT);
        if (values != null) {
            req.doidValues = IrpMessage.fromMap2Byte(values);
        }
        req.createNumber = count;
        if (this.singer != null) {
            this.singer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsBatchCreateDoidRequest(int count, byte[][] values) {
        IrpRequest req = new IrpRequest(120, DOID_DEFAULT);
        req.doidValues = values;
        req.createNumber = count;
        return req;
    }

    public IrpRequest newVerityIrsServerRequest(String doid, String address) {
        IrpRequest req = new IrpRequest(211, doid);
        req.address = GlobalUtils.encodeString(address);
        if (this.singer != null) {
            this.singer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newVerityIrsServerRequest(byte[] doid, byte[] address) {
        IrpRequest req = new IrpRequest(211, doid);
        req.address = address;
        return req;
    }
}

