/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.stateinfo;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class StateInfoBase {
    public String identifier;
    public JsonObject handleValues;
    static final String UUID_KEY = "UUID";

    public StateInfoBase() {
        this.handleValues = new JsonObject();
    }

    public StateInfoBase(JsonObject handleValues) {
        this.handleValues = handleValues == null ? new JsonObject() : handleValues;
    }

    public StateInfoBase(String identifier, JsonObject handleValues) {
        this.identifier = identifier;
        this.handleValues = handleValues == null ? new JsonObject() : handleValues;
    }

    public UUID getUUID() {
        return UUID.fromString(this.getValues(UUID_KEY));
    }

    public void setUUID(UUID uuid) {
        this.handleValues.addProperty(UUID_KEY, uuid.toString());
    }

    public static StateInfoBase fromJson(String json) {
        return (StateInfoBase)new Gson().fromJson(json, StateInfoBase.class);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public JsonObject getHandleValues() {
        return this.handleValues;
    }

    public void setHandleValues(JsonObject handleValues) {
        this.handleValues = handleValues;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getValues(String key) {
        return this.handleValues.has(key) ? this.handleValues.get(key).getAsString() : null;
    }

    public Map<String, String> getHandleValuesAsMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.handleValues != null) {
            for (String key : this.handleValues.keySet()) {
                ret.put(key, this.handleValues.get(key).getAsString());
            }
        }
        return ret;
    }
}

