/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.client;

import com.bdware.irp.util.GlobalUtils;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.bdware.irp.client.IrpClientImpl;
import org.bdware.irp.client.IrpRouterClient;
import org.bdware.irp.client.ResponseInfo;
import org.bdware.irp.exception.IrpClientException;
import org.bdware.irp.irpclient.IrpClientChannel;
import org.bdware.irp.irpclient.IrpClientChannelGenerator;
import org.bdware.irp.irpclient.IrpMessageCallback;
import org.bdware.irp.irplib.core.IrpForRouterRequest;
import org.bdware.irp.irplib.core.IrpForRouterResponse;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpRequest;
import org.bdware.irp.irplib.core.IrpRequestFactory;
import org.bdware.irp.irplib.core.IrpResponse;
import org.bdware.irp.irplib.exception.IrpConnectException;
import org.bdware.irp.stateinfo.StateInfoBase;

public class IrpRouterClientImpl
extends IrpClientImpl
implements IrpRouterClient {
    Logger logger = Logger.getLogger(IrpRouterClientImpl.class);
    Map<String, IrpClientChannel> cachedChannel = new ConcurrentHashMap<String, IrpClientChannel>();
    IrpClientChannel irpChannel;
    String serverURL = null;
    ResponseCallback rcb;
    ResponseContainer container;
    IrpResponse res;
    IrpRequestFactory factory = new IrpRequestFactory(null);

    public IrpRouterClientImpl(String LHSUrl) {
        super(null, null, LHSUrl);
        this.serverURL = LHSUrl;
        this.container = new ResponseContainer();
        this.rcb = new ResponseCallback(this.container);
    }

    @Override
    public String authInfoFromUpperRouter(String pubkey, String name, String signInfo) throws IrpClientException {
        if (pubkey == null || name == null || signInfo == null) {
            throw new IrpClientException("authinfo is null!");
        }
        IrpForRouterRequest req = IrpForRouterRequest.newVerifyRouterAuthRequest(pubkey, name, signInfo);
        this.sendMessage(req, this.rcb);
        IrpResponse res = this.waitForResponse();
        if (res.header.responseCode != 1 || !(res instanceof IrpForRouterResponse)) {
            this.logger.error((Object)("Verify the router from upper router failed: " + res.getResponseMessage()));
            throw new IrpClientException("Verify the router from upper router failed!");
        }
        IrpForRouterResponse response = (IrpForRouterResponse)res;
        ResponseInfo resInfo = new ResponseInfo(response.prefix, response.port, response.routerInfo);
        return new Gson().toJson((Object)resInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateInfoBase resolve(String doid) throws IrpClientException {
        if (doid == null) {
            throw new IrpClientException("doid is null!");
        }
        StringTokenizer token = new StringTokenizer(doid, "/");
        if (token.countTokens() < 1 || token.countTokens() > 3) {
            throw new IrpClientException("Illegal doid identifier");
        }
        String prefix = token.nextToken();
        if (token.hasMoreTokens()) {
            prefix = prefix + '/' + token.nextToken();
        }
        this.logger.debug((Object)("Resolve the doid identifier: " + prefix));
        boolean stopFlag = false;
        String nextServerUrl = this.serverURL;
        String doidInfo = null;
        while (!stopFlag) {
            try {
                this.setServerAddress(nextServerUrl);
                this.reconnect();
                IrpRequest req = this.factory.newIrsResolveRequest(prefix, null);
                this.sendMessage(req, this.rcb);
                this.res = this.waitForResponse();
                this.logger.debug((Object)this.res.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.res.header.responseCode == 1) {
                doidInfo = this.toStringFromByte2(this.res);
                Map<String, String> value = this.res.getDoidValuesByMap();
                StateInfoBase infoBase = new StateInfoBase();
                infoBase.identifier = new String(this.res.doid);
                infoBase.handleValues = JsonParser.parseString((String)doidInfo).getAsJsonObject();
                return infoBase;
            }
            if (this.res.header.responseCode == 303) {
                if (this.res.delegateTargetURL != null) {
                    nextServerUrl = !this.res.delegateTargetURL.startsWith("tcp://") ? "tcp://" + this.res.delegateTargetURL : this.res.delegateTargetURL;
                    stopFlag = false;
                    continue;
                }
                throw new IrpClientException("The next router address is wrong:" + this.res.header.responseCode);
            }
            if (this.res.header.responseCode == 2) {
                this.logger.info((Object)GlobalUtils.decodeString(this.res.responseMessage));
                stopFlag = true;
                continue;
            }
            throw new IrpClientException("Unhandled response code:" + this.res.header.responseCode);
        }
        return null;
    }

    String toStringFromByte2(IrpResponse res) {
        Map<String, String> value = res.getDoidValuesByMap();
        return new Gson().toJson(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IrpResponse waitForResponse() {
        this.container.response = null;
        ResponseCallback responseCallback = this.rcb;
        synchronized (responseCallback) {
            try {
                this.rcb.wait(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.container.response == null) {
            this.container.response = IrpResponse.newErrorResponse(0, 2, "Server response timeout!");
        }
        return this.container.response;
    }

    @Override
    public void close() {
        if (this.irpChannel != null) {
            this.irpChannel.close();
            this.irpChannel = null;
        }
    }

    public void connect() {
        try {
            this.irpChannel = this.getOrCreateChannel(this.serverURL);
            if (this.irpChannel == null) {
                return;
            }
            if (!this.irpChannel.isConnected()) {
                this.irpChannel.connect(this.serverURL);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private IrpClientChannel getOrCreateChannel(String serverURL) {
        IrpClientChannel ret;
        if (this.cachedChannel.containsKey(serverURL)) {
            ret = this.cachedChannel.get(serverURL);
        } else {
            ret = IrpClientChannelGenerator.createIrpClientChannel(serverURL);
            this.cachedChannel.put(serverURL, ret);
        }
        return ret;
    }

    public void setServerAddress(String newURL) {
        this.serverURL = newURL;
    }

    @Override
    public void reconnect() throws IrpConnectException {
        if (this.serverURL == null) {
            throw new IrpConnectException("target URL not set, use .connect(url) first");
        }
        if (this.irpChannel == null) {
            this.irpChannel = this.getOrCreateChannel(this.serverURL);
        }
        if (this.irpChannel == null) {
            return;
        }
        try {
            if (!this.irpChannel.isConnected()) {
                this.logger.debug((Object)("Reconnect the next router: " + this.serverURL));
                this.irpChannel.connect(this.serverURL);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isConnected() {
        return this.irpChannel != null && this.irpChannel.isConnected();
    }

    @Override
    public void sendMessage(IrpMessage msg, IrpMessageCallback cb) {
        this.connect();
        if (this.irpChannel == null || !this.irpChannel.isConnected()) {
            this.logger.warn((Object)"channel not connect yet!");
            return;
        }
        this.irpChannel.sendMessage(msg, cb);
    }

    static class ResponseContainer {
        IrpResponse response;

        ResponseContainer() {
        }
    }

    class ResponseCallback
    implements IrpMessageCallback {
        ResponseContainer responseContainer;

        public ResponseCallback(ResponseContainer container) {
            this.responseContainer = container;
        }

        @Override
        public synchronized void onResult(IrpMessage msg) {
            IrpRouterClientImpl.this.logger.debug((Object)("<callback>message header: " + msg.header.opCode));
            this.responseContainer.response = (IrpResponse)msg;
            this.notifyAll();
        }
    }
}

