/*
 * Decompiled with CFR 0.152.
 */
package com.bdware.irp.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDHDecrypter;
import com.nimbusds.jose.crypto.ECDHEncrypter;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertUtils {
    static Logger logger = Logger.getLogger(CertUtils.class);

    public static String Sign(byte[] data, JWK jwk) throws Exception {
        JWSObject jwsObject;
        RSASSASigner jwsSigner;
        if (jwk.getKeyType() == KeyType.RSA) {
            jwsSigner = new RSASSASigner(jwk.toRSAKey());
            jwsObject = new JWSObject(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(jwk.getKeyID()).build(), new Payload(data));
        } else if (jwk.getKeyType() == KeyType.EC) {
            jwsSigner = new ECDSASigner(jwk.toECKey());
            jwsObject = new JWSObject(new JWSHeader.Builder(JWSAlgorithm.ES256).keyID(jwk.getKeyID()).build(), new Payload(data));
        } else {
            logger.error((Object)"unsupported Algorithm");
            throw new NoSuchAlgorithmException("unsupported Algorithm");
        }
        jwsObject.sign((JWSSigner)jwsSigner);
        String s = jwsObject.serialize(true);
        return s;
    }

    public static boolean verify(byte[] payload, String jws, JWK pkToVerify) throws Exception {
        RSASSAVerifier verifier;
        JWSObject signature = JWSObject.parse((String)jws, (Payload)new Payload(payload));
        if (pkToVerify.getKeyType() == KeyType.RSA) {
            verifier = new RSASSAVerifier(pkToVerify.toRSAKey().toRSAPublicKey());
        } else if (pkToVerify.getKeyType() == KeyType.EC) {
            verifier = new ECDSAVerifier(pkToVerify.toECKey().toECPublicKey());
        } else {
            logger.error((Object)"unsupported Algorithm");
            return false;
        }
        return signature.verify((JWSVerifier)verifier);
    }

    public static byte[] encrypt(byte[] payload, JWK pkToEncrypt) throws JOSEException {
        JWEObject jweObject;
        logger.debug((Object)"===do encryption");
        EncryptionMethod enc = EncryptionMethod.A256GCM;
        if (pkToEncrypt.getKeyType() == KeyType.RSA) {
            JWEAlgorithm alg = JWEAlgorithm.RSA_OAEP_256;
            jweObject = new JWEObject(new JWEHeader(alg, enc), new Payload(payload));
            jweObject.encrypt((JWEEncrypter)new RSAEncrypter(pkToEncrypt.toRSAKey().toRSAPublicKey()));
        } else if (pkToEncrypt.getKeyType() == KeyType.EC) {
            JWEAlgorithm alg = JWEAlgorithm.ECDH_ES;
            jweObject = new JWEObject(new JWEHeader(alg, enc), new Payload(payload));
            jweObject.encrypt((JWEEncrypter)new ECDHEncrypter(pkToEncrypt.toECKey().toECPublicKey()));
        } else {
            throw new JOSEException("only support RSA or EC key");
        }
        return jweObject.serialize().getBytes();
    }

    public static byte[] decrypt(byte[] cipherText, JWK skToDecrypt) throws ParseException, JOSEException {
        logger.debug((Object)"===do decryption");
        JWEObject decrypt = JWEObject.parse((String)new String(cipherText));
        if (skToDecrypt.getKeyType() == KeyType.RSA) {
            decrypt.decrypt((JWEDecrypter)new RSADecrypter((PrivateKey)skToDecrypt.toRSAKey().toRSAPrivateKey()));
        } else if (skToDecrypt.getKeyType() == KeyType.EC) {
            decrypt.decrypt((JWEDecrypter)new ECDHDecrypter(skToDecrypt.toECKey().toECPrivateKey()));
        } else {
            throw new JOSEException("only support RSA or EC key");
        }
        return decrypt.getPayload().toBytes();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

