/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpclient;

import java.net.URI;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.bdware.irp.irpclient.IrpClientChannel;
import org.bdware.irp.irpclient.NettyIrpClientChannel;

public class IrpClientChannelGenerator {
    static Logger logger = Logger.getLogger(IrpClientChannelGenerator.class);
    static HashMap<String, IrpClientChannel> adhocClient = new HashMap();

    public static IrpClientChannel createIrpClientChannel(String url) {
        try {
            URI uri = new URI(url);
            logger.debug((Object)("[URI Parse]scheme:" + uri.getScheme() + " host: " + uri.getHost() + "  port: " + uri.getPort()));
            switch (uri.getScheme()) {
                case "tcp": 
                case "TCP": 
                case "udp": 
                case "UDP": {
                    return NettyIrpClientChannel.createByServerUrl(url);
                }
            }
            if (adhocClient.get(uri.getScheme()) != null) {
                return adhocClient.get(uri.getScheme());
            }
            logger.error((Object)("[Create server error] Unsupported URL: " + url));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addClient(String schema, IrpClientChannel channel) {
        adhocClient.put(schema, channel);
    }
}

