/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.core;

import com.bdware.irp.util.GlobalUtils;
import java.util.Map;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.exception.IrpMessageDecodeException;

public class IrpRequest
extends IrpMessage {
    public byte[] doid;
    public byte[][] doidValues = null;
    public byte[][] requestedKeys = null;
    public byte[] address;
    public int createNumber = 0;

    public IrpRequest(int opCode, String doid) {
        super(opCode, 0);
        this.doid = GlobalUtils.encodeString(doid);
    }

    public IrpRequest(int opCode, byte[] doid) {
        super(opCode, 0);
        this.doid = doid;
    }

    public Map<String, String> getDoidValuesByMap() {
        Map<String, String> result = null;
        try {
            result = IrpRequest.fromBytes2Map(this.doidValues);
        }
        catch (IrpMessageDecodeException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isAuthNeeded() {
        if (this.header != null) {
            return this.header.getCertifiedFlag();
        }
        return false;
    }

    @Override
    public String getDoid() {
        return GlobalUtils.decodeString(this.doid);
    }

    public String getAddress() {
        return GlobalUtils.decodeString(this.address);
    }
}

