/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpMessageEnvelope;
import org.bdware.irp.irplib.exception.IrpMessageDecodeException;
import org.bdware.irp.irplib.exception.IrpMessageEncodeException;
import org.bdware.irp.irplib.util.EncoderUtils;

public class IrpMessagePacket {
    public byte[] envelopePacket = new byte[20];
    public byte[] bodyPacket = null;
    public IrpMessageEnvelope irpMessageEnvelope = new IrpMessageEnvelope();

    public static ArrayList<IrpMessagePacket> irpMessageToPackets(IrpMessage msg) throws IrpMessageEncodeException {
        ArrayList<IrpMessagePacket> messagePackets = new ArrayList<IrpMessagePacket>();
        ByteBuf bf = Unpooled.directBuffer();
        int messageLength = msg.getEncodedMessage().length;
        bf.writeBytes(msg.encodedMessage);
        int totalNumber = messageLength / 262144 + 1;
        while (bf.isReadable()) {
            IrpMessagePacket packet = new IrpMessagePacket();
            if (bf.readableBytes() < 262144) {
                packet.bodyPacket = new byte[bf.readableBytes()];
                bf.readBytes(packet.bodyPacket);
            } else {
                packet.bodyPacket = new byte[262144];
                bf.readBytes(packet.bodyPacket);
            }
            packet.irpMessageEnvelope.setTruncated(totalNumber > 1);
            packet.irpMessageEnvelope.setEnCrypted(msg.header.getEncryptionFlag());
            packet.irpMessageEnvelope.sequenceNumber = messagePackets.size();
            packet.irpMessageEnvelope.requestId = msg.envelope.requestId;
            packet.irpMessageEnvelope.messageLength = messageLength;
            packet.envelopePacket = packet.irpMessageEnvelope.getEncodeEnvelope();
            messagePackets.add(packet);
        }
        bf.release();
        return messagePackets;
    }

    public static IrpMessagePacket irpMessageToTCPPackets(IrpMessage msg) throws IrpMessageEncodeException {
        IrpMessagePacket messagePacket = new IrpMessagePacket();
        int messageLength = msg.getEncodedMessage().length;
        if (messageLength > 262144) {
            throw new IrpMessageEncodeException("The message length is more than the TCP packet limited!");
        }
        messagePacket.bodyPacket = msg.encodedMessage;
        messagePacket.irpMessageEnvelope.setTruncated(false);
        messagePacket.irpMessageEnvelope.setEnCrypted(msg.header.getEncryptionFlag());
        messagePacket.irpMessageEnvelope.sequenceNumber = 0;
        messagePacket.irpMessageEnvelope.requestId = msg.envelope.requestId;
        messagePacket.irpMessageEnvelope.messageLength = messageLength;
        messagePacket.envelopePacket = messagePacket.irpMessageEnvelope.getEncodeEnvelope();
        return messagePacket;
    }

    public static IrpMessage packetTCPToIrpMessage(IrpMessagePacket packet) throws IrpMessageDecodeException {
        IrpMessageEnvelope envelope = new IrpMessageEnvelope();
        EncoderUtils.decodeMessageEnvelope(packet.envelopePacket, envelope);
        IrpMessage msg = EncoderUtils.decodeMessage(packet.bodyPacket, 0, envelope);
        msg.envelope = envelope;
        return msg;
    }

    public static IrpMessagePacket bytesToMessagePacket(byte[] packetBytes) throws IrpMessageDecodeException {
        IrpMessagePacket packet = new IrpMessagePacket();
        int bodyLength = packetBytes.length - 20;
        System.arraycopy(packetBytes, 0, packet.envelopePacket, 0, 20);
        EncoderUtils.decodeMessageEnvelope(packet.envelopePacket, packet.irpMessageEnvelope);
        packet.bodyPacket = new byte[bodyLength];
        System.arraycopy(packetBytes, 20, packet.bodyPacket, 0, bodyLength);
        return packet;
    }

    public static byte[] toBytes(IrpMessagePacket packet) {
        byte[] packetBytes = new byte[20 + packet.bodyPacket.length];
        System.arraycopy(packet.envelopePacket, 0, packetBytes, 0, 20);
        System.arraycopy(packet.bodyPacket, 0, packetBytes, 20, packet.bodyPacket.length);
        return packetBytes;
    }
}

