/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.util;

import com.bdware.irp.util.GlobalUtils;
import org.apache.log4j.Logger;
import org.bdware.irp.irplib.core.HandleRequest;
import org.bdware.irp.irplib.core.HandleResponse;
import org.bdware.irp.irplib.core.IrpForRouterRequest;
import org.bdware.irp.irplib.core.IrpForRouterResponse;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpMessageCredential;
import org.bdware.irp.irplib.core.IrpMessageEnvelope;
import org.bdware.irp.irplib.core.IrpMessageHeader;
import org.bdware.irp.irplib.core.IrpRequest;
import org.bdware.irp.irplib.core.IrpRequestFactory;
import org.bdware.irp.irplib.core.IrpResponse;
import org.bdware.irp.irplib.exception.IrpMessageDecodeException;
import org.bdware.irp.irplib.exception.IrpMessageEncodeException;

public class EncoderUtils {
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    private static Logger logger = Logger.getLogger(EncoderUtils.class);
    static IrpRequestFactory factory = new IrpRequestFactory(null);

    public static final int writeShortToBuffer(short value, byte[] buf, int offset) {
        buf[offset++] = (byte)((value & 0xFF00) >> 8);
        buf[offset++] = (byte)(value & 0xFF);
        return 2;
    }

    public static final short readShortFromBuffer(byte[] buf, int offset) {
        short value = (short)((buf[offset] & 0xFF) << 8 | buf[offset + 1] & 0xFF);
        return value;
    }

    public static final int writeIntToBuffer(int value, byte[] buf, int offset) {
        buf[offset++] = (byte)(value >> 24 & 0xFF);
        buf[offset++] = (byte)(value >> 16 & 0xFF);
        buf[offset++] = (byte)(value >> 8 & 0xFF);
        buf[offset++] = (byte)(value & 0xFF);
        return 4;
    }

    public static final int readIntFromBuffer(byte[] buf, int offset) {
        int value = (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
        return value;
    }

    public static final int writeLongToBuffer(long value, byte[] buf, int offset) {
        buf[offset++] = (byte)(value >> 56 & 0xFFL);
        buf[offset++] = (byte)(value >> 48 & 0xFFL);
        buf[offset++] = (byte)(value >> 40 & 0xFFL);
        buf[offset++] = (byte)(value >> 32 & 0xFFL);
        buf[offset++] = (byte)(value >> 24 & 0xFFL);
        buf[offset++] = (byte)(value >> 16 & 0xFFL);
        buf[offset++] = (byte)(value >> 8 & 0xFFL);
        buf[offset++] = (byte)(value & 0xFFL);
        return 8;
    }

    public static final long readLongFromBuffer(byte[] buf, int offset) {
        long value = ((long)buf[offset] & 0xFFL) << 56 | ((long)buf[offset + 1] & 0xFFL) << 48 | ((long)buf[offset + 2] & 0xFFL) << 40 | ((long)buf[offset + 3] & 0xFFL) << 32 | ((long)buf[offset + 4] & 0xFFL) << 24 | ((long)buf[offset + 5] & 0xFFL) << 16 | ((long)buf[offset + 6] & 0xFFL) << 8 | (long)buf[offset + 7] & 0xFFL;
        return value;
    }

    public static final int writeStringByteToBuffer(byte[] value, byte[] buf, int offset) {
        if (value == null) {
            return EncoderUtils.writeIntToBuffer(0, buf, offset);
        }
        int byteLength = value.length;
        EncoderUtils.writeIntToBuffer(byteLength, buf, offset);
        System.arraycopy(value, 0, buf, offset + 4, byteLength);
        return byteLength + 4;
    }

    public static final byte[] readStringByteFromBuffer(byte[] buf, int offset) throws IrpMessageDecodeException {
        int byteLength = EncoderUtils.readIntFromBuffer(buf, offset);
        if (byteLength < 0 || byteLength > 0x100000) {
            throw new IrpMessageDecodeException("Decode UTF-8 String bytes from the bytesBuffer error!");
        }
        byte[] stringValue = new byte[byteLength];
        System.arraycopy(buf, offset + 4, stringValue, 0, byteLength);
        return stringValue;
    }

    public static final int writeStringByteArrayToBuffer(byte[][] values, byte[] buf, int offset) {
        if (values == null) {
            return EncoderUtils.writeIntToBuffer(0, buf, offset);
        }
        int arrayLength = values.length;
        int offsetLength = EncoderUtils.writeIntToBuffer(arrayLength, buf, offset);
        for (byte[] value : values) {
            offsetLength += EncoderUtils.writeStringByteToBuffer(value, buf, offset + offsetLength);
        }
        return offsetLength;
    }

    public static final byte[][] readStringByteArrayFromBuffer(byte[] buf, int offset) throws IrpMessageDecodeException {
        Object byteArray = null;
        int arrayLength = EncoderUtils.readIntFromBuffer(buf, offset);
        int offsetPos = offset + 4;
        if (arrayLength < 0 || arrayLength > 128) {
            throw new IrpMessageDecodeException("Decode UTF-8 String bytes from the bytesBuffer error!");
        }
        byteArray = new byte[arrayLength][];
        for (int i = 0; i < arrayLength; ++i) {
            byteArray[i] = EncoderUtils.readStringByteFromBuffer(buf, offsetPos);
            offsetPos += byteArray[i].length + 4;
        }
        return byteArray;
    }

    public static final int writeIntArrayToBuffer(int[] values, byte[] buf, int offset) {
        if (values == null) {
            return EncoderUtils.writeIntToBuffer(0, buf, offset);
        }
        int intLength = values.length;
        int offsetLength = EncoderUtils.writeIntToBuffer(intLength, buf, offset);
        for (int value : values) {
            offsetLength += EncoderUtils.writeIntToBuffer(value, buf, offset + offsetLength);
        }
        return offsetLength;
    }

    public static final int[] readIntArrayFromBuffer(byte[] buf, int offset) throws IrpMessageDecodeException {
        int arrayLength = EncoderUtils.readIntFromBuffer(buf, offset);
        if (arrayLength < 0 || arrayLength > 128) {
            throw new IrpMessageDecodeException("Decode UTF-8 String bytes from the bytesBuffer error!");
        }
        int[] intArray = new int[arrayLength];
        int offsetPos = offset + 4;
        for (int i = 0; i < arrayLength; ++i) {
            intArray[i] = EncoderUtils.readIntFromBuffer(buf, offsetPos);
            offsetPos += 4;
        }
        return intArray;
    }

    public static final byte[] encodeMessageEnvelope(IrpMessageEnvelope envelope) {
        int offsetPos = 0;
        byte[] buf = new byte[20];
        buf[offsetPos++] = envelope.majorVersion;
        buf[offsetPos++] = envelope.minVersion;
        offsetPos += EncoderUtils.writeShortToBuffer(envelope.getMessageFlagByFlags(), buf, offsetPos);
        offsetPos += EncoderUtils.writeIntToBuffer(envelope.sessionId, buf, offsetPos);
        offsetPos += EncoderUtils.writeIntToBuffer(envelope.requestId, buf, offsetPos);
        offsetPos += EncoderUtils.writeIntToBuffer(envelope.sequenceNumber, buf, offsetPos);
        offsetPos += EncoderUtils.writeIntToBuffer(envelope.messageLength, buf, offsetPos);
        return buf;
    }

    public static final void decodeMessageEnvelope(byte[] buf, IrpMessageEnvelope envelope) throws IrpMessageDecodeException {
        boolean offsetPos = false;
        if (buf == null || buf.length < 20) {
            throw new IrpMessageDecodeException("Decode failed: invalid message envelope!");
        }
        envelope.majorVersion = buf[0];
        envelope.minVersion = buf[1];
        envelope.setFlagsByMessageFlag(EncoderUtils.readShortFromBuffer(buf, 2));
        envelope.sessionId = EncoderUtils.readIntFromBuffer(buf, 4);
        envelope.requestId = EncoderUtils.readIntFromBuffer(buf, 8);
        envelope.sequenceNumber = EncoderUtils.readIntFromBuffer(buf, 12);
        envelope.messageLength = EncoderUtils.readIntFromBuffer(buf, 16);
        if (envelope.messageLength < 0 || envelope.messageLength > 262144) {
            throw new IrpMessageDecodeException("Decode failed: invalid message body length!");
        }
    }

    public static final int encodeMessageHeader(IrpMessageHeader header, byte[] buf, int bodyLen) {
        int offsetPos = 0;
        offsetPos += EncoderUtils.writeIntToBuffer(header.opCode, buf, offsetPos);
        offsetPos += EncoderUtils.writeIntToBuffer(header.responseCode, buf, offsetPos);
        offsetPos += EncoderUtils.writeIntToBuffer(header.getOpFlagByFlags(), buf, offsetPos);
        offsetPos += EncoderUtils.writeShortToBuffer(header.siteInfoSerialNumber, buf, offsetPos);
        buf[offsetPos++] = header.recursionCount;
        ++offsetPos;
        offsetPos += EncoderUtils.writeIntToBuffer(header.expirationTime, buf, offsetPos);
        header.bodyLength = bodyLen;
        offsetPos += EncoderUtils.writeIntToBuffer(bodyLen, buf, offsetPos);
        return 24;
    }

    public static final void decodeMessageHeader(byte[] buf, IrpMessageHeader header, int offset) throws IrpMessageDecodeException {
        int offsetPos = offset;
        if (buf == null || buf.length < 24) {
            throw new IrpMessageDecodeException("Decode failed: invalid message header!");
        }
        header.opCode = EncoderUtils.readIntFromBuffer(buf, offsetPos);
        header.responseCode = EncoderUtils.readIntFromBuffer(buf, offsetPos += 4);
        header.setFlagsByOpFlag(EncoderUtils.readIntFromBuffer(buf, offsetPos += 4));
        header.siteInfoSerialNumber = EncoderUtils.readShortFromBuffer(buf, offsetPos += 4);
        offsetPos += 2;
        header.recursionCount = buf[offsetPos++];
        header.expirationTime = EncoderUtils.readIntFromBuffer(buf, ++offsetPos);
        header.bodyLength = EncoderUtils.readIntFromBuffer(buf, offsetPos += 4);
        if (header.bodyLength < 0) {
            throw new IrpMessageDecodeException("Decode failed: invalid message body length!");
        }
    }

    public static final byte[] encodeMessageCredential(IrpMessageCredential credential) {
        credential.signedInfoLength = 4 + credential.signedInfoDigestAlgorithm.length + 4 + credential.signature.length;
        credential.credentialLength = 8 + credential.signerDoid.length + 4 + credential.signedInfoType.length + 4 + 4 + credential.signedInfoDigestAlgorithm.length + 4 + credential.signature.length;
        int offsetPos = 0;
        byte[] credentialByteBuffer = new byte[4 + credential.credentialLength];
        offsetPos += EncoderUtils.writeIntToBuffer(credential.credentialLength, credentialByteBuffer, offsetPos);
        credentialByteBuffer[offsetPos++] = credential.version;
        credentialByteBuffer[offsetPos++] = credential.reserved;
        offsetPos += EncoderUtils.writeShortToBuffer(credential.options, credentialByteBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteToBuffer(credential.signerDoid, credentialByteBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteToBuffer(credential.signedInfoType, credentialByteBuffer, offsetPos);
        offsetPos += EncoderUtils.writeIntToBuffer(credential.signedInfoLength, credentialByteBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteToBuffer(credential.signedInfoDigestAlgorithm, credentialByteBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteToBuffer(credential.signature, credentialByteBuffer, offsetPos);
        return credentialByteBuffer;
    }

    public static final void decodeMessageCredential(byte[] buf, int offset, IrpMessageCredential credential) throws IrpMessageDecodeException {
        if (buf == null || buf.length < 0) {
            throw new IrpMessageDecodeException("Decode failed: invalid message credential!");
        }
        int offsetPos = offset;
        credential.credentialLength = EncoderUtils.readIntFromBuffer(buf, offsetPos);
        offsetPos += 4;
        credential.version = buf[offsetPos++];
        credential.reserved = buf[offsetPos++];
        credential.options = EncoderUtils.readShortFromBuffer(buf, offsetPos);
        credential.signerDoid = EncoderUtils.readStringByteFromBuffer(buf, offsetPos += 2);
        credential.signedInfoType = EncoderUtils.readStringByteFromBuffer(buf, offsetPos += 4 + credential.signerDoid.length);
        credential.signedInfoLength = EncoderUtils.readIntFromBuffer(buf, offsetPos += 4 + credential.signedInfoType.length);
        credential.signedInfoDigestAlgorithm = EncoderUtils.readStringByteFromBuffer(buf, offsetPos += 4);
        credential.signature = EncoderUtils.readStringByteFromBuffer(buf, offsetPos += 4 + credential.signedInfoDigestAlgorithm.length);
        if (credential.signedInfoLength != 4 + credential.signedInfoDigestAlgorithm.length + 4 + credential.signature.length) {
            throw new IrpMessageDecodeException("Decode failed: invalid message credential signature length!");
        }
    }

    public static final byte[] encodeMessageBody(IrpMessage msg) throws IrpMessageEncodeException {
        byte[] bodyBuffer = null;
        int opCode = msg.header.opCode;
        int responseCode = msg.header.responseCode;
        block0 : switch (responseCode) {
            case 0: {
                switch (opCode) {
                    case 11: {
                        bodyBuffer = EncoderUtils.encodeResolveDoidRequestBody((IrpRequest)msg);
                        break block0;
                    }
                    case 212: {
                        bodyBuffer = EncoderUtils.encodeResolveDoidRequestBody((IrpRequest)msg);
                        break block0;
                    }
                    case 213: {
                        bodyBuffer = EncoderUtils.encodeCreateDoidRequestBody((IrpRequest)msg);
                        break block0;
                    }
                    case 110: {
                        bodyBuffer = EncoderUtils.encodeCreateDoidRequestBody((IrpRequest)msg);
                        break block0;
                    }
                    case 120: {
                        bodyBuffer = EncoderUtils.encodeBatchCreateDoidRequestBody((IrpRequest)msg);
                        break block0;
                    }
                    case 111: {
                        bodyBuffer = EncoderUtils.encodeDeleteDoidRequestBody((IrpRequest)msg);
                        break block0;
                    }
                    case 117: {
                        bodyBuffer = EncoderUtils.encodeUpdateDoidRequestBody((IrpRequest)msg);
                        break block0;
                    }
                    case 211: {
                        bodyBuffer = EncoderUtils.encodeVerifyIrsRequestBody((IrpRequest)msg);
                        break block0;
                    }
                    case 1: {
                        bodyBuffer = EncoderUtils.encodeResolveHandleRequestBody((HandleRequest)msg);
                        break block0;
                    }
                    case 800: {
                        bodyBuffer = EncoderUtils.encodeVerifyRouterRequestBody((IrpForRouterRequest)msg);
                        break block0;
                    }
                    case 802: {
                        bodyBuffer = EncoderUtils.encodeQueryIdentifiersRequestBody((IrpRequest)msg);
                        break block0;
                    }
                }
                throw new IrpMessageEncodeException("Invalid opCode for the irp request: " + opCode);
            }
            case 1: {
                IrpResponse res = (IrpResponse)msg;
                switch (opCode) {
                    case 11: {
                        bodyBuffer = EncoderUtils.encodeResolveDoidResponseBody(res);
                        break block0;
                    }
                    case 110: {
                        bodyBuffer = EncoderUtils.encodeCreateDoidResponseBody(res);
                        break block0;
                    }
                    case 120: {
                        bodyBuffer = EncoderUtils.encodeBatchCreateDoidResponseBody(res);
                        break block0;
                    }
                    case 111: {
                        bodyBuffer = EncoderUtils.encodeDeleteDoidResponseBody(res);
                        break block0;
                    }
                    case 117: {
                        bodyBuffer = EncoderUtils.encodeUpdateDoidResponseBody(res);
                        break block0;
                    }
                    case 211: {
                        bodyBuffer = EncoderUtils.encodeVerifyIrsResponseBody(res);
                        break block0;
                    }
                    case 213: {
                        bodyBuffer = EncoderUtils.encodeCreateDoidResponseBody(res);
                        break block0;
                    }
                    case 800: {
                        bodyBuffer = EncoderUtils.encodeVerifyRouterResponseBody((IrpForRouterResponse)res);
                        break block0;
                    }
                    case 802: {
                        bodyBuffer = EncoderUtils.encodeQueryIdentifiersResponseBody(res);
                        break block0;
                    }
                }
                throw new IrpMessageEncodeException("Invalid opCode for the irp response: " + opCode);
            }
            case 2: {
                bodyBuffer = EncoderUtils.encodeErrorResponseBody((IrpResponse)msg);
                break;
            }
            case 303: {
                bodyBuffer = EncoderUtils.encodeDelegateResponseBody((IrpResponse)msg);
                break;
            }
            default: {
                throw new IrpMessageEncodeException("Invalid responseCode for the message: " + responseCode);
            }
        }
        if (bodyBuffer == null) {
            logger.error((Object)("Encode message body error [ " + msg.toString() + " ]"));
            throw new IrpMessageEncodeException("Encode message body error!");
        }
        return bodyBuffer;
    }

    public static final IrpMessage decodeMessage(byte[] msgBuf, int offset, IrpMessageEnvelope envelope) throws IrpMessageDecodeException {
        IrpMessageHeader header = new IrpMessageHeader();
        IrpMessage msg = null;
        EncoderUtils.decodeMessageHeader(msgBuf, header, offset);
        int opCode = header.opCode;
        int responseCode = header.responseCode;
        int offsetPos = offset + 24;
        block0 : switch (responseCode) {
            case 0: {
                switch (opCode) {
                    case 11: {
                        msg = EncoderUtils.decodeResolveDoidRequestBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 212: {
                        msg = EncoderUtils.decodeResolveDoidRequestBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 213: {
                        msg = EncoderUtils.decodeCreateDoidRequestBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 110: {
                        msg = EncoderUtils.decodeCreateDoidRequestBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 120: {
                        msg = EncoderUtils.decodeBatchCreateDoidRequestBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 111: {
                        msg = EncoderUtils.decodeDeleteDoidRequestBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 117: {
                        msg = EncoderUtils.decodeUpdateDoidRequestBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 211: {
                        msg = EncoderUtils.decodeVerifyIrsRequestBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 800: {
                        msg = EncoderUtils.decodeVerifyRouterRequestBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 802: {
                        msg = EncoderUtils.decodeQueryIdentifiersRequestBody(header, msgBuf, offsetPos);
                        break block0;
                    }
                }
                throw new IrpMessageDecodeException("Decode failed: Invalid opCode for the irp request: " + opCode);
            }
            case 1: {
                switch (opCode) {
                    case 11: {
                        msg = EncoderUtils.decodeResolveDoidResponseBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 110: {
                        msg = EncoderUtils.decodeCreateDoidResponseBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 120: {
                        msg = EncoderUtils.decodeBatchCreateDoidResponseBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 111: {
                        msg = EncoderUtils.decodeDeleteDoidResponseBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 117: {
                        msg = EncoderUtils.decodeUpdateDoidResponseBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 211: {
                        msg = EncoderUtils.decodeVerifyIrsResponseBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 1: {
                        msg = EncoderUtils.decodeResolveHandleResponseBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 213: {
                        msg = EncoderUtils.decodeCreateDoidResponseBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 800: {
                        msg = EncoderUtils.decodeVerifyRouterResponseBody(msgBuf, offsetPos);
                        break block0;
                    }
                    case 802: {
                        msg = EncoderUtils.decodeQueryIdentifiersResponseBody(header, msgBuf, offsetPos);
                        break block0;
                    }
                }
                throw new IrpMessageDecodeException("Decode failed: Invalid opCode for the irp response: " + opCode);
            }
            case 2: {
                msg = EncoderUtils.decodeErrorResponseBody(opCode, responseCode, msgBuf, offsetPos);
                break;
            }
            case 303: {
                msg = EncoderUtils.decodeDelegateResponseBody(msgBuf, offsetPos);
                break;
            }
            default: {
                throw new IrpMessageDecodeException("Invalid responseCode for the message: " + responseCode);
            }
        }
        if (msg == null) {
            logger.error((Object)("Decode message body error [ " + msg.toString() + " ]"));
            throw new IrpMessageDecodeException("Decode message body error!");
        }
        msg.encodedMessageBody = new byte[24 + header.bodyLength];
        System.arraycopy(msgBuf, offset, msg.encodedMessageBody, 0, 24 + header.bodyLength);
        msg.envelope = envelope;
        msg.header = header;
        if (offset + envelope.messageLength >= (offsetPos += header.bodyLength) + 4) {
            int creLength = EncoderUtils.readIntFromBuffer(msgBuf, offsetPos);
            if (creLength < 0 || creLength != offset + envelope.messageLength - offsetPos - 4) {
                throw new IrpMessageDecodeException("Decode failed: invalid message credential!");
            }
            if (creLength == 0) {
                msg.credential.credentialLength = 0;
                msg.encodedCredential = null;
            } else {
                EncoderUtils.decodeMessageCredential(msgBuf, offsetPos, msg.credential);
                msg.encodedCredential = new byte[msg.credential.credentialLength];
                System.arraycopy(msgBuf, offsetPos, msg.encodedCredential, 0, msg.credential.credentialLength);
            }
        }
        return msg;
    }

    public static final byte[] encodeResolveDoidRequestBody(IrpRequest req) {
        int resolveKeysLength = 0;
        if (req.requestedKeys != null) {
            for (byte[] requestedKey : req.requestedKeys) {
                resolveKeysLength += 4 + requestedKey.length;
            }
        }
        int bodyLength = 4 + req.doid.length + 4 + resolveKeysLength;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(req.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeStringByteToBuffer(req.doid, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteArrayToBuffer(req.requestedKeys, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpRequest decodeResolveDoidRequestBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        int offsetPos = offset;
        byte[] doid = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos);
        byte[][] requestedKeys = EncoderUtils.readStringByteArrayFromBuffer(msgBuf, offsetPos += 4 + doid.length);
        return factory.newIrsResolveRequest(doid, requestedKeys);
    }

    public static final byte[] encodeResolveDoidResponseBody(IrpResponse res) {
        int bodyLength = 4 + res.doid.length + 4 + (res.requestDigestNeeded ? 1 + res.requestDigest.length : 0);
        if (res.doidValues != null) {
            for (byte[] value : res.doidValues) {
                bodyLength += 4 + value.length;
            }
        }
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(res.header, bodyBuffer, bodyLength);
        if (res.requestDigestNeeded) {
            // empty if block
        }
        offsetPos += EncoderUtils.writeStringByteToBuffer(res.doid, bodyBuffer, offsetPos);
        if (res.doidValues != null) {
            EncoderUtils.writeStringByteArrayToBuffer(res.doidValues, bodyBuffer, offsetPos);
        } else {
            EncoderUtils.writeIntToBuffer(0, bodyBuffer, offsetPos);
        }
        return bodyBuffer;
    }

    public static final IrpResponse decodeResolveDoidResponseBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        int offsetPos = offset;
        byte[] doid = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos);
        int valuesLength = EncoderUtils.readIntFromBuffer(msgBuf, offsetPos += 4 + doid.length);
        byte[][] requestedValues = null;
        if (valuesLength != 0) {
            requestedValues = EncoderUtils.readStringByteArrayFromBuffer(msgBuf, offsetPos);
        }
        return IrpResponse.newIrsResolveResponse(doid, requestedValues);
    }

    public static final byte[] encodeCreateDoidRequestBody(IrpRequest req) {
        int valuesLength = 0;
        if (req.doidValues != null) {
            for (byte[] doidValue : req.doidValues) {
                valuesLength += 4 + doidValue.length;
            }
        }
        int bodyLength = 4 + req.doid.length + 4 + valuesLength;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(req.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeStringByteToBuffer(req.doid, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteArrayToBuffer(req.doidValues, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpRequest decodeCreateDoidRequestBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        int offsetPos = offset;
        byte[] doid = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos);
        byte[][] doidValues = EncoderUtils.readStringByteArrayFromBuffer(msgBuf, offsetPos += 4 + doid.length);
        return factory.newIrsCreateDoidRequest(doid, doidValues);
    }

    public static final byte[] encodeCreateDoidResponseBody(IrpResponse res) {
        int bodyLength = 4 + res.doid.length + (res.requestDigestNeeded ? 1 + res.requestDigest.length : 0);
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(res.header, bodyBuffer, bodyLength);
        if (res.requestDigestNeeded) {
            // empty if block
        }
        offsetPos += EncoderUtils.writeStringByteToBuffer(res.doid, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpResponse decodeCreateDoidResponseBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        byte[] doid = EncoderUtils.readStringByteFromBuffer(msgBuf, offset);
        return IrpResponse.newIrsCreateDoidResponse(doid);
    }

    public static final byte[] encodeBatchCreateDoidRequestBody(IrpRequest req) {
        int valuesLength = 0;
        if (req.doidValues != null) {
            for (byte[] doidValue : req.doidValues) {
                valuesLength += 4 + doidValue.length;
            }
        }
        int bodyLength = 8 + valuesLength;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(req.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeIntToBuffer(req.createNumber, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteArrayToBuffer(req.doidValues, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpRequest decodeBatchCreateDoidRequestBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        int offsetPos = offset;
        int count = EncoderUtils.readIntFromBuffer(msgBuf, offsetPos);
        byte[][] doidValues = EncoderUtils.readStringByteArrayFromBuffer(msgBuf, offsetPos += 4);
        return factory.newIrsBatchCreateDoidRequest(count, doidValues);
    }

    public static final byte[] encodeBatchCreateDoidResponseBody(IrpResponse res) {
        int doidsLength = 0;
        if (res.doids != null) {
            for (byte[] doidEl : res.doids) {
                doidsLength += 4 + doidEl.length;
            }
        }
        int bodyLength = 4 + doidsLength + (res.requestDigestNeeded ? 1 + res.requestDigest.length : 0);
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(res.header, bodyBuffer, bodyLength);
        if (res.requestDigestNeeded) {
            // empty if block
        }
        offsetPos += EncoderUtils.writeStringByteArrayToBuffer(res.doids, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpResponse decodeBatchCreateDoidResponseBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        byte[][] doids = EncoderUtils.readStringByteArrayFromBuffer(msgBuf, offset);
        return IrpResponse.newIrsBatchCreateDoidResponse(doids);
    }

    public static final byte[] encodeUpdateDoidRequestBody(IrpRequest req) {
        int valuesLength = 0;
        if (req.doidValues != null) {
            for (byte[] doidValue : req.doidValues) {
                valuesLength += 4 + doidValue.length;
            }
        }
        int bodyLength = 4 + req.doid.length + 4 + valuesLength;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(req.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeStringByteToBuffer(req.doid, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteArrayToBuffer(req.doidValues, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpRequest decodeUpdateDoidRequestBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        int offsetPos = offset;
        byte[] doid = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos);
        byte[][] doidValues = EncoderUtils.readStringByteArrayFromBuffer(msgBuf, offsetPos += 4 + doid.length);
        return factory.newIrsUpdateDoidRequest(doid, doidValues);
    }

    public static final byte[] encodeUpdateDoidResponseBody(IrpResponse res) {
        int bodyLength = 4 + res.doid.length + (res.requestDigestNeeded ? 1 + res.requestDigest.length : 0);
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(res.header, bodyBuffer, bodyLength);
        if (res.requestDigestNeeded) {
            // empty if block
        }
        offsetPos += EncoderUtils.writeStringByteToBuffer(res.doid, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpResponse decodeUpdateDoidResponseBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        byte[] doid = EncoderUtils.readStringByteFromBuffer(msgBuf, offset);
        return IrpResponse.newIrsUpdateDoidResponse(doid);
    }

    public static final byte[] encodeDeleteDoidRequestBody(IrpRequest req) {
        int bodyLength = 4 + req.doid.length;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(req.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeStringByteToBuffer(req.doid, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpRequest decodeDeleteDoidRequestBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        byte[] doid = EncoderUtils.readStringByteFromBuffer(msgBuf, offset);
        return factory.newIrsDeleteDoidRequest(doid);
    }

    public static final byte[] encodeDeleteDoidResponseBody(IrpResponse res) {
        int bodyLength = 4 + res.doid.length + (res.requestDigestNeeded ? 1 + res.requestDigest.length : 0);
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(res.header, bodyBuffer, bodyLength);
        if (res.requestDigestNeeded) {
            // empty if block
        }
        offsetPos += EncoderUtils.writeStringByteToBuffer(res.doid, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpResponse decodeDeleteDoidResponseBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        byte[] doid = EncoderUtils.readStringByteFromBuffer(msgBuf, offset);
        return IrpResponse.newIrsDeleteDoidResponse(doid);
    }

    public static final byte[] encodeErrorResponseBody(IrpResponse res) {
        int bodyLength = 4 + res.responseMessage.length + (res.requestDigestNeeded ? 1 + res.requestDigest.length : 0);
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(res.header, bodyBuffer, bodyLength);
        if (res.requestDigestNeeded) {
            // empty if block
        }
        EncoderUtils.writeStringByteToBuffer(res.responseMessage, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpResponse decodeErrorResponseBody(int opCode, int responseCode, byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        byte[] responseMessage = EncoderUtils.readStringByteFromBuffer(msgBuf, offset);
        return IrpResponse.newErrorResponse(opCode, responseCode, responseMessage);
    }

    public static final byte[] encodeDelegateResponseBody(IrpResponse res) {
        byte[] urlBuffer = GlobalUtils.encodeString(res.delegateTargetURL);
        int bodyLength = 4 + urlBuffer.length + (res.requestDigestNeeded ? 1 + res.requestDigest.length : 0);
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(res.header, bodyBuffer, bodyLength);
        if (res.requestDigestNeeded) {
            // empty if block
        }
        EncoderUtils.writeStringByteToBuffer(urlBuffer, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpResponse decodeDelegateResponseBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        byte[] urlInfo = EncoderUtils.readStringByteFromBuffer(msgBuf, offset);
        return IrpResponse.newDelegateRouterResponse(GlobalUtils.decodeString(urlInfo));
    }

    public static final byte[] encodeVerifyIrsRequestBody(IrpRequest req) {
        int bodyLength = 4 + req.doid.length + 4 + req.address.length;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(req.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeStringByteToBuffer(req.doid, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteToBuffer(req.address, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpRequest decodeVerifyIrsRequestBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        int offsetPos = offset;
        byte[] doid = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos);
        byte[] address = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos += 4 + doid.length);
        return factory.newVerityIrsServerRequest(doid, address);
    }

    public static final byte[] encodeVerifyIrsResponseBody(IrpResponse res) {
        int bodyLength = 4 + res.doid.length + 4 + res.responseMessage.length + (res.requestDigestNeeded ? 1 + res.requestDigest.length : 0);
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(res.header, bodyBuffer, bodyLength);
        if (res.requestDigestNeeded) {
            // empty if block
        }
        offsetPos += EncoderUtils.writeStringByteToBuffer(res.doid, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteToBuffer(res.responseMessage, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpResponse decodeVerifyIrsResponseBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        int offsetPos = offset;
        byte[] doid = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos);
        byte[] result = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos += 4 + doid.length);
        return IrpResponse.newVerifyIrsResponse(doid, result);
    }

    public static final byte[] encodeResolveHandleRequestBody(HandleRequest req) {
        int resolveTypesLength = 0;
        if (req.handleTypes != null) {
            for (byte[] requestedType : req.handleTypes) {
                resolveTypesLength += 4 + requestedType.length;
            }
        }
        int bodyLength = 4 + req.handle.length + 4 + (req.handleIndexes == null ? 0 : req.handleIndexes.length) * 4 + 4 + resolveTypesLength;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(req.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeStringByteToBuffer(req.handle, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeIntArrayToBuffer(req.handleIndexes, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteArrayToBuffer(req.handleTypes, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final HandleResponse decodeResolveHandleResponseBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        int offsetPos = offset;
        byte[] handle = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos);
        int valuesLength = EncoderUtils.readIntFromBuffer(msgBuf, offsetPos += 4 + handle.length);
        offsetPos += 4;
        Object handleValues = null;
        if (valuesLength != 0) {
            handleValues = new byte[valuesLength][];
            for (int i = 0; i < valuesLength; ++i) {
                int valLen = EncoderUtils.calculateHandleValueSize(msgBuf, offsetPos);
                handleValues[i] = new byte[valLen];
                System.arraycopy(msgBuf, offsetPos, handleValues[i], 0, valLen);
                offsetPos += valLen;
            }
        }
        return HandleResponse.newResolveHandleResponse(handle, handleValues);
    }

    public static final int calculateHandleValueSize(byte[] msgBuf, int offset) {
        int origOffset = offset;
        int fieldLen = EncoderUtils.readIntFromBuffer(msgBuf, offset += 14);
        offset += 4 + fieldLen;
        fieldLen = EncoderUtils.readIntFromBuffer(msgBuf, offset);
        offset += 4 + fieldLen;
        fieldLen = EncoderUtils.readIntFromBuffer(msgBuf, offset);
        offset += 4;
        for (int i = 0; i < fieldLen; ++i) {
            int refLen = EncoderUtils.readIntFromBuffer(msgBuf, offset);
            offset += 4 + refLen + 4;
        }
        return offset - origOffset;
    }

    public static final byte[] encodeVerifyRouterRequestBody(IrpForRouterRequest req) {
        byte[] pubkeyBuffer = GlobalUtils.encodeString(req.pubkey);
        byte[] nameBuffer = GlobalUtils.encodeString(req.name);
        byte[] singInfoBuffer = GlobalUtils.encodeString(req.signInfo);
        int bodyLength = 4 + pubkeyBuffer.length + 4 + nameBuffer.length + 4 + singInfoBuffer.length;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(req.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeStringByteToBuffer(pubkeyBuffer, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteToBuffer(nameBuffer, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteToBuffer(singInfoBuffer, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpForRouterRequest decodeVerifyRouterRequestBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        int offsetPos = offset;
        byte[] pubkeyBuffer = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos);
        String pubkey = GlobalUtils.decodeString(pubkeyBuffer);
        byte[] nameBuff = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos += 4 + pubkeyBuffer.length);
        String name = GlobalUtils.decodeString(nameBuff);
        byte[] singInfoBuffer = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos += 4 + nameBuff.length);
        String signInfo = GlobalUtils.decodeString(singInfoBuffer);
        return IrpForRouterRequest.newVerifyRouterAuthRequest(pubkey, name, signInfo);
    }

    public static final byte[] encodeVerifyRouterResponseBody(IrpForRouterResponse res) {
        byte[] prefixBuffer = GlobalUtils.encodeString(res.prefix);
        byte[] routerInfoBuffer = GlobalUtils.encodeString(res.routerInfo);
        int bodyLength = 4 + prefixBuffer.length + 4 + routerInfoBuffer.length + 4;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(res.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeStringByteToBuffer(prefixBuffer, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeIntToBuffer(res.port, bodyBuffer, offsetPos);
        offsetPos += EncoderUtils.writeStringByteToBuffer(routerInfoBuffer, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpForRouterResponse decodeVerifyRouterResponseBody(byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        int offsetPos = offset;
        byte[] prefixBuffer = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos);
        String prefix = GlobalUtils.decodeString(prefixBuffer);
        int port = EncoderUtils.readIntFromBuffer(msgBuf, offsetPos += 4 + prefixBuffer.length);
        byte[] routerInfoBuffer = EncoderUtils.readStringByteFromBuffer(msgBuf, offsetPos += 4);
        String routerInfo = GlobalUtils.decodeString(routerInfoBuffer);
        offsetPos += 4 + routerInfoBuffer.length;
        return IrpForRouterResponse.newVerifyRouterAuthResponse(prefix, port, routerInfo);
    }

    public static final byte[] encodeQueryIdentifiersRequestBody(IrpRequest req) {
        int valuesLength = 0;
        if (req.doidValues != null) {
            for (byte[] doidValue : req.doidValues) {
                valuesLength += 4 + doidValue.length;
            }
        }
        int bodyLength = 4 + valuesLength;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(req.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeStringByteArrayToBuffer(req.doidValues, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpRequest decodeQueryIdentifiersRequestBody(IrpMessageHeader header, byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        IrpRequest resp = new IrpRequest(802, (String)null);
        resp.header = header;
        resp.doidValues = EncoderUtils.readStringByteArrayFromBuffer(msgBuf, offset);
        return resp;
    }

    public static final byte[] encodeQueryIdentifiersResponseBody(IrpResponse res) {
        int valuesLength = 0;
        if (res.doidValues != null) {
            for (byte[] doidValue : res.doidValues) {
                valuesLength += 4 + doidValue.length;
            }
        }
        int bodyLength = 4 + valuesLength;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(res.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeStringByteArrayToBuffer(res.doidValues, bodyBuffer, offsetPos);
        return bodyBuffer;
    }

    public static final IrpResponse decodeQueryIdentifiersResponseBody(IrpMessageHeader header, byte[] msgBuf, int offset) throws IrpMessageDecodeException {
        IrpResponse resp = new IrpResponse(802, 1);
        resp.header = header;
        resp.doidValues = EncoderUtils.readStringByteArrayFromBuffer(msgBuf, offset);
        return resp;
    }

    public static final byte[] encodeResolveRouterRequestBody(IrpForRouterRequest req) {
        int bodyLength = 4 + req.doid.length;
        byte[] bodyBuffer = new byte[bodyLength + 24];
        int offsetPos = 0;
        offsetPos += EncoderUtils.encodeMessageHeader(req.header, bodyBuffer, bodyLength);
        offsetPos += EncoderUtils.writeStringByteToBuffer(req.doid, bodyBuffer, offsetPos);
        return bodyBuffer;
    }
}

