/*
 * Decompiled with CFR 0.152.
 */
package com.bdware.irp.client;

import com.bdware.irp.client.CdiIrpClient;
import com.bdware.irp.client.InternalIrpClient;
import com.nimbusds.jose.jwk.JWK;
import java.util.List;
import org.bdware.irp.client.IrpClient;
import org.bdware.irp.exception.IrpClientException;
import org.bdware.irp.stateinfo.StateInfoBase;

public class GeneralIrpClient
implements IrpClient {
    CdiIrpClient cdiIrpClient;
    InternalIrpClient internalIrpClient;

    public GeneralIrpClient(JWK kp, String clientID, String LHSUrl) {
        this.cdiIrpClient = new CdiIrpClient(kp, clientID, LHSUrl);
        this.internalIrpClient = new InternalIrpClient(kp, clientID, LHSUrl);
    }

    @Override
    public StateInfoBase resolve(String handle) throws IrpClientException {
        return this.internalIrpClient.resolve(handle);
    }

    @Override
    public String register(StateInfoBase hr) throws IrpClientException {
        if (hr.identifier != null && !hr.identifier.contains("_bdw")) {
            return this.cdiIrpClient.register(hr);
        }
        return this.internalIrpClient.register(hr);
    }

    @Override
    public String reRegister(StateInfoBase hr) throws IrpClientException {
        if (hr.identifier != null && !hr.identifier.contains("_bdw")) {
            return this.cdiIrpClient.reRegister(hr);
        }
        return this.internalIrpClient.reRegister(hr);
    }

    @Override
    public String unRegister(String handle) {
        if (handle != null && !handle.contains("_bdw")) {
            return this.cdiIrpClient.unRegister(handle);
        }
        return this.internalIrpClient.unRegister(handle);
    }

    @Override
    public List<String> batchRegister(StateInfoBase hr, int count) throws IrpClientException {
        if (hr.identifier != null && !hr.identifier.contains("_bdw")) {
            return this.cdiIrpClient.batchRegister(hr, count);
        }
        return this.internalIrpClient.batchRegister(hr, count);
    }
}

