package com.bdware.irp;

import com.nimbusds.jose.jwk.JWK;
import com.bdware.irp.util.GlobalUtils;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpMessageSigner;
import org.bdware.irp.irplib.util.IrpCommon;

import java.security.Signature;

public class JWKSigner implements IrpMessageSigner {
    JWK jwk;


    public JWKSigner(JWK jwk) {
        this.jwk = jwk;
    }

    //sign the massage by Signature, need init first
    public final void signMessage(IrpMessage irpMessage, Signature signer) {
        try {
            //generate the message signature data first
            byte[] digestData = irpMessage.getEncodedMessageHeaderBody();
            signer.update(digestData);
            irpMessage.credential.signedInfoType = IrpCommon.CREDENTIAL_SIGNEDINFO_TYPE_RSA;
            irpMessage.credential.signedInfoDigestAlgorithm = GlobalUtils.getDigestAlgFromSignature(signer.getAlgorithm());
            irpMessage.credential.signature = signer.sign();
            irpMessage.encodedMessage = null;  //update the encode message
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    //sign the massage by JWK
    public static final void signMessage(IrpMessage irpMessage, JWK jwk) {
        try {
            if (jwk == null) return;
            irpMessage.header.setCertifiedFlag(true);
            //generate the message signature data first
            byte[] digestData = irpMessage.getEncodedMessageHeaderBody();
            //not digest the body and header, sign immediately
            String signature = GlobalUtils.signByteArrayByJWK(digestData, jwk);
            irpMessage.credential.signerDoid = GlobalUtils.encodeString(jwk.getKeyID());
            irpMessage.credential.signedInfoType = IrpCommon.CREDENTIAL_SIGNEDINFO_TYPE_JWK;
            irpMessage.credential.signedInfoDigestAlgorithm = IrpCommon.CREDENTIAL_DIGEST_ALG_JWK;
            irpMessage.credential.signature = GlobalUtils.encodeString(signature);
            irpMessage.credential.signedInfoLength = irpMessage.credential.signedInfoDigestAlgorithm.length + irpMessage.credential.signature.length;
            irpMessage.encodedMessage = null;  //update the encode message
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void signMessage(IrpMessage irpMessage) {
        signMessage(irpMessage, jwk);
    }

}
