/*
 * Decompiled with CFR 0.152.
 */
package com.bdware.irp;

import com.bdware.irp.util.GlobalUtils;
import com.nimbusds.jose.jwk.JWK;
import java.security.Signature;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpMessageSigner;
import org.bdware.irp.irplib.util.IrpCommon;

public class JWKSigner
implements IrpMessageSigner {
    JWK jwk;

    public JWKSigner(JWK jwk) {
        this.jwk = jwk;
    }

    @Override
    public final void signMessage(IrpMessage irpMessage, Signature signer) {
        try {
            byte[] digestData = irpMessage.getEncodedMessageHeaderBody();
            signer.update(digestData);
            irpMessage.credential.signedInfoType = IrpCommon.CREDENTIAL_SIGNEDINFO_TYPE_RSA;
            irpMessage.credential.signedInfoDigestAlgorithm = GlobalUtils.getDigestAlgFromSignature(signer.getAlgorithm());
            irpMessage.credential.signature = signer.sign();
            irpMessage.encodedMessage = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void signMessage(IrpMessage irpMessage, JWK jwk) {
        try {
            if (jwk == null) {
                return;
            }
            irpMessage.header.setCertifiedFlag(true);
            byte[] digestData = irpMessage.getEncodedMessageHeaderBody();
            String signature = GlobalUtils.signByteArrayByJWK(digestData, jwk);
            irpMessage.credential.signerDoid = GlobalUtils.encodeString(jwk.getKeyID());
            irpMessage.credential.signedInfoType = IrpCommon.CREDENTIAL_SIGNEDINFO_TYPE_JWK;
            irpMessage.credential.signedInfoDigestAlgorithm = IrpCommon.CREDENTIAL_DIGEST_ALG_JWK;
            irpMessage.credential.signature = GlobalUtils.encodeString(signature);
            irpMessage.credential.signedInfoLength = irpMessage.credential.signedInfoDigestAlgorithm.length + irpMessage.credential.signature.length;
            irpMessage.encodedMessage = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void signMessage(IrpMessage irpMessage) {
        JWKSigner.signMessage(irpMessage, this.jwk);
    }
}

