/*
 * Decompiled with CFR 0.152.
 */
package com.bdware.irp.util;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irplib.exception.IrpMessageCredentialException;
import org.bdware.irp.irplib.util.IrpCommon;

public class GlobalUtils {
    private static Logger logger = LogManager.getLogger(GlobalUtils.class);

    public static final byte[] encodeString(String str) {
        try {
            return str.getBytes("UTF8");
        }
        catch (Exception e) {
            logger.error(str + " encode to bytes failed!");
            return null;
        }
    }

    public static final String decodeString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        try {
            return new String(bytes, "UTF8");
        }
        catch (Exception e) {
            logger.error(new String(bytes) + " decode to string failed!");
            return null;
        }
    }

    public static final byte[] getDigestAlgFromSignature(String sigAlgorithm) throws IrpMessageCredentialException {
        if (sigAlgorithm.startsWith("SHA1")) {
            return IrpCommon.CREDENTIAL_DIGEST_ALG_SHA1;
        }
        if (sigAlgorithm.startsWith("MD5")) {
            return IrpCommon.CREDENTIAL_DIGEST_ALG_MD5;
        }
        throw new IrpMessageCredentialException("Unsupported digest algorithm for signature: " + sigAlgorithm);
    }

    public static final String signByteArrayByJWK(byte[] data, JWK jwk) throws JOSEException {
        JWSObject jwsObject;
        RSASSASigner jwsSigner;
        if (jwk.getKeyType() == KeyType.RSA) {
            jwsSigner = new RSASSASigner(jwk.toRSAKey());
            jwsObject = new JWSObject(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(jwk.getKeyID()).build(), new Payload(data));
        } else if (jwk.getKeyType() == KeyType.EC) {
            jwsSigner = new ECDSASigner(jwk.toECKey());
            jwsObject = new JWSObject(new JWSHeader.Builder(JWSAlgorithm.ES256).keyID(jwk.getKeyID()).build(), new Payload(data));
        } else {
            logger.error("unsupported jwk Algorithm");
            return null;
        }
        jwsObject.sign((JWSSigner)jwsSigner);
        return jwsObject.serialize(true);
    }

    public static final boolean verifySigByJWK(byte[] messageBody, String signature, String pkInfo) {
        if (messageBody == null || signature == null || pkInfo == null) {
            logger.error("SignatureInfo missing!");
            return false;
        }
        try {
            RSASSAVerifier verifier;
            JWSObject verify = JWSObject.parse((String)signature, (Payload)new Payload(messageBody));
            JWK pkToVerify = JWK.parse((String)pkInfo);
            if (pkToVerify.getKeyType() == KeyType.RSA) {
                verifier = new RSASSAVerifier(pkToVerify.toRSAKey().toRSAPublicKey());
            } else if (pkToVerify.getKeyType() == KeyType.EC) {
                verifier = new ECDSAVerifier(pkToVerify.toECKey().toECPublicKey());
            } else {
                logger.error("unsupported Algorithm");
                return false;
            }
            if (verify.verify((JWSVerifier)verifier)) {
                return true;
            }
            logger.error("verify the message failed!");
            return false;
        }
        catch (ParseException e) {
            logger.error("parse the pk error");
            return false;
        }
        catch (JOSEException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static JWK loadKeysFromJWKFile(String jwkFilePath) throws IOException, ParseException {
        FileInputStream fi = new FileInputStream(jwkFilePath);
        byte[] jwkB = new byte[fi.available()];
        fi.read(jwkB);
        String jwkS = new String(jwkB);
        logger.info(jwkS);
        return JWK.parse((String)jwkS);
    }

    public static JWK loadKeysFromJWKStr(String jwkStr) throws ParseException {
        return JWK.parse((String)jwkStr);
    }
}

