/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.core;

public class IrpMessageHeader {
    public int opCode;
    public int responseCode;
    private int opFlag;
    public short siteInfoSerialNumber;
    public byte recursionCount;
    public byte reservedSpace;
    public int expirationTime;
    public int bodyLength;
    private boolean authoritativeFlag;
    private boolean certifiedFlag;
    private boolean encryptionFlag;
    private boolean recursiveFlag;
    private boolean cacheAuthenticationFlag;
    private boolean contiNuousFlag;
    private boolean keepConnectionFlag;
    private boolean publicOnlyFlag;
    private boolean requestDigestFlag;

    public IrpMessageHeader() {
        this.opCode = 0;
        this.responseCode = 0;
        this.siteInfoSerialNumber = 0;
        this.recursionCount = 0;
        this.reservedSpace = 0;
        this.expirationTime = 0;
        this.bodyLength = 0;
        this.setFlagsByOpFlag(0);
    }

    public IrpMessageHeader(int opCode) {
        this.opCode = opCode;
    }

    public IrpMessageHeader(int opCode, int responseCode) {
        this.opCode = opCode;
        this.responseCode = responseCode;
    }

    public IrpMessageHeader(int opCode, int responseCode, int opFlag, short siteInfoSerialNumber, byte recursionCount, int expirationTime, int bodyLength) {
        this.opCode = opCode;
        this.responseCode = responseCode;
        this.siteInfoSerialNumber = siteInfoSerialNumber;
        this.recursionCount = recursionCount;
        this.reservedSpace = 0;
        this.expirationTime = expirationTime;
        this.bodyLength = bodyLength;
        this.setFlagsByOpFlag(opFlag);
    }

    public void setFlagsByOpFlag(int opFlag) {
        this.opFlag = opFlag;
        this.authoritativeFlag = opFlag < 0;
        this.certifiedFlag = opFlag << 1 < 0;
        this.encryptionFlag = opFlag << 2 < 0;
        this.recursiveFlag = opFlag << 3 < 0;
        this.cacheAuthenticationFlag = opFlag << 4 < 0;
        this.contiNuousFlag = opFlag << 5 < 0;
        this.keepConnectionFlag = opFlag << 6 < 0;
        this.publicOnlyFlag = opFlag << 7 < 0;
        this.requestDigestFlag = opFlag << 8 < 0;
    }

    public int getOpFlagByFlags() {
        this.opFlag = 0;
        if (this.authoritativeFlag) {
            this.opFlag |= Integer.MIN_VALUE;
        }
        if (this.certifiedFlag) {
            this.opFlag |= 0x40000000;
        }
        if (this.encryptionFlag) {
            this.opFlag |= 0x20000000;
        }
        if (this.recursiveFlag) {
            this.opFlag |= 0x10000000;
        }
        if (this.cacheAuthenticationFlag) {
            this.opFlag |= 0x8000000;
        }
        if (this.contiNuousFlag) {
            this.opFlag |= 0x4000000;
        }
        if (this.keepConnectionFlag) {
            this.opFlag |= 0x2000000;
        }
        if (this.publicOnlyFlag) {
            this.opFlag |= 0x1000000;
        }
        if (this.requestDigestFlag) {
            this.opFlag |= 0x800000;
        }
        return this.opFlag;
    }

    public boolean getAuthoritativeFlag() {
        return this.authoritativeFlag;
    }

    public boolean getCertifiedFlag() {
        return this.certifiedFlag;
    }

    public boolean getEncryptionFlag() {
        return this.encryptionFlag;
    }

    public boolean getRecursiveFlag() {
        return this.recursiveFlag;
    }

    public boolean getCacheAuthenticationFlag() {
        return this.cacheAuthenticationFlag;
    }

    public boolean getContiNuousFlag() {
        return this.contiNuousFlag;
    }

    public boolean getKeepConnectionFlag() {
        return this.keepConnectionFlag;
    }

    public boolean getPublicOnlyFlag() {
        return this.publicOnlyFlag;
    }

    public boolean getRequestDigestFlag() {
        return this.requestDigestFlag;
    }

    public void setAuthoritativeFlag(boolean authoritativeFlag) {
        this.authoritativeFlag = authoritativeFlag;
    }

    public void setCertifiedFlag(boolean certifiedFlag) {
        this.certifiedFlag = certifiedFlag;
    }

    public void setEncryptionFlag(boolean encryptionFlag) {
        this.encryptionFlag = encryptionFlag;
    }

    public void setRecursiveFlag(boolean recursiveFlag) {
        this.recursiveFlag = recursiveFlag;
    }

    public void setCacheAuthenticationFlag(boolean cacheAuthenticationFlag) {
        this.cacheAuthenticationFlag = cacheAuthenticationFlag;
    }

    public void setContiNuousFlag(boolean contiNuousFlag) {
        this.contiNuousFlag = contiNuousFlag;
    }

    public void setKeepConnectionFlag(boolean keepConnectionFlag) {
        this.keepConnectionFlag = keepConnectionFlag;
    }

    public void setPublicOnlyFlag(boolean publicOnlyFlag) {
        this.publicOnlyFlag = publicOnlyFlag;
    }

    public void setRequestDigestFlag(boolean requestDigestFlag) {
        this.requestDigestFlag = requestDigestFlag;
    }
}

