/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpResponse;
import org.bdware.irp.irpserver.IrpRequestHandler;

@ChannelHandler.Sharable
public class NettyServerHandler
extends SimpleChannelInboundHandler<IrpMessage> {
    static Logger logger = LogManager.getLogger(NettyServerHandler.class);
    protected IrpRequestHandler requestHandler;
    private int streamPushInterval = 500;

    public NettyServerHandler(IrpRequestHandler irpHandler) {
        this.requestHandler = irpHandler;
    }

    protected void channelRead0(ChannelHandlerContext ctx, IrpMessage msg) {
        if (msg.header == null) {
            this.replyStringWithStatus(ctx, msg, "invalid request", 2);
            return;
        }
        IrpMessage response = this.requestHandler.onRequest(msg);
        if (response != null) {
            response.envelope.requestId = msg.envelope.requestId;
            this.sendResponse(ctx, response);
        } else {
            this.defaultHandler(ctx, msg);
        }
    }

    public void defaultHandler(ChannelHandlerContext ctx, IrpMessage request) {
        this.replyStringWithStatus(ctx, request, "Unsupported Operation!", 2);
    }

    protected void replyStringWithStatus(ChannelHandlerContext ctx, IrpMessage request, String str, int responseCode) {
        IrpResponse response = IrpResponse.newErrorResponse(request.header.opCode, responseCode, str);
        response.envelope.requestId = request.envelope.requestId;
        this.sendResponse(ctx, response);
    }

    public void sendResponse(ChannelHandlerContext ctx, IrpMessage response) {
        ctx.writeAndFlush((Object)response);
    }
}

