/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.bdware.irp.irplib.crypto.NettyTCPCodeC;
import org.bdware.irp.irpserver.NettyServerHandler;

public class IrpListenerInfo {
    public String host;
    public int port;
    public String protocolType;
    public int workerGroupThreadSize;

    public IrpListenerInfo(String protocolType) {
        this(2641, protocolType);
    }

    public IrpListenerInfo(int port, String protocolType) {
        this("127.0.0.1", port, protocolType);
    }

    public IrpListenerInfo(String host, int port, String protocolType) {
        this(host, port, protocolType, -1);
    }

    public IrpListenerInfo(String host, int port, String protocolType, int workerGroupThreadSize) {
        this.host = host;
        this.port = port;
        this.protocolType = protocolType;
        this.workerGroupThreadSize = workerGroupThreadSize;
    }

    public ChannelInitializer<SocketChannel> createChannelInitializer(final NettyServerHandler serverHandler) {
        return new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(262144, 16, 4, 0, 0)}).addLast(new ChannelHandler[]{new NettyTCPCodeC()}).addLast(new ChannelHandler[]{serverHandler});
            }
        };
    }
}

