/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpserver;

import io.netty.channel.ChannelHandlerContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpResponse;
import org.bdware.irp.irpserver.GrsHandler;
import org.bdware.irp.irpserver.IrpRequestHandler;
import org.bdware.irp.irpserver.IrsHandler;
import org.bdware.irp.irpserver.NettyIrpListener;
import org.bdware.irp.irpserver.RouterHandler;

public class IrpRequestHandlerImpl
implements IrpRequestHandler {
    static Logger logger = LogManager.getLogger(NettyIrpListener.class);
    IrsHandler irsHandler;
    GrsHandler grsHandler;
    RouterHandler routerHandler;

    public void setIrsHandler(IrsHandler irsHandler) {
        this.irsHandler = irsHandler;
    }

    public void setGrsHandler(GrsHandler grsHandler) {
        this.grsHandler = grsHandler;
    }

    public void setRouterHandler(RouterHandler routerHandler) {
        this.routerHandler = routerHandler;
    }

    @Override
    public IrpMessage onRequest(ChannelHandlerContext ctx, IrpMessage msg) {
        IrpMessage res;
        int opCode = msg.header.opCode;
        logger.debug("[Call operation] name: " + opCode);
        switch (opCode) {
            case 11: {
                res = this.irsHandler.doidResolve(msg);
                break;
            }
            case 110: {
                res = this.irsHandler.createDOID(msg);
                break;
            }
            case 111: {
                res = this.irsHandler.deleteDOID(msg);
                break;
            }
            case 117: {
                res = this.irsHandler.updateDOID(msg);
                break;
            }
            case 120: {
                res = this.irsHandler.batchCreateDOID(msg);
                break;
            }
            case 211: {
                res = this.grsHandler.verifyIRS(msg);
                break;
            }
            case 213: {
                res = this.grsHandler.createOrg(msg);
                break;
            }
            case 214: {
                res = this.grsHandler.updateOrg(msg);
                break;
            }
            case 215: {
                res = this.grsHandler.deleteOrg(msg);
                break;
            }
            case 212: {
                res = this.grsHandler.doidResolve(msg);
                break;
            }
            case 800: {
                res = this.routerHandler.verifyChildRouter(msg);
                break;
            }
            case 802: {
                res = this.routerHandler.queryIdentifierByOffset(msg);
                break;
            }
            default: {
                logger.debug("Unknown opcode to handler");
                res = IrpResponse.newErrorResponse(opCode, 2, "Unknown opcode to handler");
            }
        }
        return res;
    }
}

