/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpclient;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicChannelBootstrap;
import io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irpclient.IrpMessageCallback;
import org.bdware.irp.irpclient.NettyIrpClientChannel;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.crypto.NettyTCPCodeC;

public class NettyIrpQuicClientChannel
extends NettyIrpClientChannel {
    static Logger logger = LogManager.getLogger(NettyIrpQuicClientChannel.class);
    final Bootstrap b = new Bootstrap();
    static EventLoopGroup group = new NioEventLoopGroup();
    QuicChannelBootstrap qcb;

    public NettyIrpQuicClientChannel() {
        QuicSslContext context = QuicSslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocols(new String[]{"irp/3.0"}).build();
        ChannelHandler codec = ((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)new QuicClientCodecBuilder().sslContext(context)).maxIdleTimeout(5000L, TimeUnit.MILLISECONDS)).initialMaxData(10000000L)).initialMaxStreamDataBidirectionalLocal(1000000L)).build();
        Channel channel = ((Bootstrap)((Bootstrap)((Bootstrap)this.b.group(group)).channel(NioDatagramChannel.class)).handler(codec)).bind(0).channel();
        this.qcb = QuicChannel.newBootstrap((Channel)channel).handler((ChannelHandler)new LengthFieldBasedFrameDecoder(262144, 16, 4, 0, 0)).handler((ChannelHandler)new NettyTCPCodeC()).handler((ChannelHandler)this.handler);
    }

    @Override
    public void sendMessage(IrpMessage request, IrpMessageCallback callback) {
    }

    @Override
    public void close() {
        if (this.handler != null) {
            this.handler.close();
        }
        this.isConnected = false;
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException {
        URI uri = new URI(targetUrl);
        logger.debug("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort());
        try {
            this.channel = (Channel)this.qcb.remoteAddress((SocketAddress)new InetSocketAddress(uri.getHost(), uri.getPort())).connect().get();
            this.handler.setChannel(this.channel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isConnected = true;
    }

    @Override
    public boolean isConnected() {
        return false;
    }
}

