package org.bdware.irp.irplib.core;

import org.bdware.irp.irplib.util.EncoderUtils;

import java.util.HashMap;
import java.util.Map;

public class IrpRequestFactory {
    public static final String DOID_DEFAULT = "doidForCreate";
    public IrpMessageSigner singer;

    public IrpRequestFactory(IrpMessageSigner signer) {
        this.singer = signer;
    }

    public IrpRequest newIrsResolveRequest(String doid, String[] keys) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_RESOLUTION_DOID, doid);
        if (keys != null) {
            req.requestedKeys = new byte[keys.length][];
            for (int i = 0; i < keys.length; i++) {
                req.requestedKeys[i] = EncoderUtils.encodeString(keys[i]);
            }
        }
        return req;
    }

    public IrpRequest newIrsResolveRecursiveRequest(String doid, String[] keys) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_RESOLUTION_DOID_RECURSIVE, doid);
        if (keys != null) {
            req.requestedKeys = new byte[keys.length][];
            for (int i = 0; i < keys.length; i++) {
                req.requestedKeys[i] = EncoderUtils.encodeString(keys[i]);
            }
        }
        HashMap<String, String> values = new HashMap<>();
        values.put("recursiveFlag", "true");
        req.doidValues = IrpMessage.fromMap2Byte(values);

        return req;
    }

    public IrpRequest newGrsResolveRequest(String doid, String[] keys) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_RESOLVE_GRS, doid);
        if (keys != null) {
            req.requestedKeys = new byte[keys.length][];
            for (int i = 0; i < keys.length; i++) {
                req.requestedKeys[i] = EncoderUtils.encodeString(keys[i]);
            }
        }
        return req;
    }

    public IrpRequest newGrsCreateOrgRequest(String doi, Map<String, String> values) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_CREATE_ORG_GRS, doi);
        if (values != null) {
            req.doidValues = IrpMessage.fromMap2Byte(values);
        }
        if (singer != null)
            singer.signMessage(req);
        return req;
    }

    public IrpRequest newIrsSynOrgToParentRequest(String doi, Map<String, String> values) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_CREATE_ORG_GRS, doi);
        if (values != null) {
            req.doidValues = IrpMessage.fromMap2Byte(values);
        }
        if (singer != null)
            singer.signMessage(req);
        return req;
    }

    public IrpRequest newIrsResolveRequest(byte[] doid, byte[][] keys, byte[][] doidValues) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_RESOLUTION_DOID, doid);
        req.requestedKeys = keys;
        req.doidValues = doidValues;
        return req;
    }

    public IrpRequest newIrsResolveRequest(byte[] doid, byte[][] keys) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_RESOLUTION_DOID, doid);
        req.requestedKeys = keys;
        return req;
    }

    public IrpRequest newIrsCreateDoidRequest(Map<String, String> values) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_CREATE_DOID, DOID_DEFAULT);
        if (values != null) {
            req.doidValues = IrpMessage.fromMap2Byte(values);
        }
        if (singer != null)
            singer.signMessage(req);
        return req;
    }

    public IrpRequest newIrsCreateDoidRequest(byte[] doid, byte[][] values) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_CREATE_DOID, doid);
        req.doidValues = values;
        if (singer != null)
            singer.signMessage(req);
        return req;
    }

    public IrpRequest newIrsUpdateDoidRequest(String doid, Map<String, String> values) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_UPDATE_DOID, doid);
        if (values != null) {
            req.doidValues = IrpMessage.fromMap2Byte(values);
        }
        if (singer != null)
            singer.signMessage(req);
        return req;
    }

    public IrpRequest newIrsUpdateDoidRequest(byte[] doid, byte[][] values) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_UPDATE_DOID, doid);
        req.doidValues = values;
        return req;
    }

    public IrpRequest newIrsDeleteDoidRequest(String doid) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_DELETE_DOID, doid);
        if (singer != null)
            singer.signMessage(req);
        return req;
    }

    public IrpRequest newIrsDeleteDoidRequest(byte[] doid) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_DELETE_DOID, doid);
        return req;
    }

    public IrpRequest newIrsBatchCreateDoidRequest(Map<String, String> values, int count) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_BATCH_CREATE_DOID, DOID_DEFAULT);
        if (values != null) {
            req.doidValues = IrpMessage.fromMap2Byte(values);
        }
        req.createNumber = count;
        if (singer != null)
            singer.signMessage(req);
        return req;
    }

    public IrpRequest newIrsBatchCreateDoidRequest(int count, byte[][] values) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_BATCH_CREATE_DOID, DOID_DEFAULT);
        req.doidValues = values;
        req.createNumber = count;
        return req;
    }

    public IrpRequest newVerityIrsServerRequest(String doid, String address) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_VERIFY_IRS, doid);
        req.address = EncoderUtils.encodeString(address);
        if (singer != null)
            singer.signMessage(req);
        return req;
    }

    public IrpRequest newVerityIrsServerRequest(byte[] doid, byte[] address) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_VERIFY_IRS, doid);
        req.address = address;
        return req;
    }

    public IrpRequest newQueryRouterInfo() {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_QUERY_ROUTER, DOID_DEFAULT);
        Map<String, String> values = new HashMap<>();
        values.put("routerInfo", "true");
        req.doidValues = IrpMessage.fromMap2Byte(values);
        if (singer != null)
            singer.signMessage(req);
        return req;
    }

    public IrpRequest newQueryDOByOffsetRequest(int offset, int count, boolean queryByCreateTime) {
        IrpRequest req = new IrpRequest(IrpMessageCode.OC_QUERY_ROUTER, DOID_DEFAULT);
        Map<String, String> values = new HashMap<>();
        values.put("offset", offset + "");
        values.put("count", count + "");
        if (queryByCreateTime)
            values.put("queryByCreateTime", "true");
        req.doidValues = IrpMessage.fromMap2Byte(values);
        if (singer != null)
            singer.signMessage(req);
        return req;
    }

}
