/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.core;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irplib.core.IrpResponse;
import org.bdware.irp.irplib.exception.IrpMessageDecodeException;
import org.bdware.irp.irplib.util.EncoderUtils;

public class HandleResponse
extends IrpResponse {
    private static Logger logger = LogManager.getLogger(EncoderUtils.class);
    public byte[] handle;
    public byte[][] values;

    public HandleResponse(int opCode, int resCode) {
        super(opCode, resCode);
        this.requestDigest = null;
    }

    public static HandleResponse newResolveHandleResponse(byte[] handle, byte[][] values) {
        HandleResponse res = new HandleResponse(1, 1);
        res.handle = handle;
        res.requestDigestNeeded = false;
        res.values = values;
        return res;
    }

    public String getHandle() {
        return EncoderUtils.decodeString(this.handle);
    }

    public HandleValue[] getHandleValues() {
        try {
            HandleValue[] retValues = new HandleValue[this.values.length];
            for (int i = 0; i < retValues.length; ++i) {
                retValues[i] = this.decodeHandleValue(this.values[i]);
            }
            return retValues;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("encode the handle values error");
            return null;
        }
    }

    public String getHandleValuesAsJson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(HandleValue.class, (Object)new HandleValueAdapter());
        gsonBuilder.registerTypeAdapter(ValueReference.class, (Object)new ValueReferenceAdapter());
        return gsonBuilder.create().toJson((Object)this.getHandleValues());
    }

    public HandleValue decodeHandleValue(byte[] buf) throws IrpMessageDecodeException {
        int offsetPos = 0;
        HandleValue value = new HandleValue();
        value.index = EncoderUtils.readIntFromBuffer(buf, offsetPos);
        value.timestamp = EncoderUtils.readIntFromBuffer(buf, offsetPos += 4);
        offsetPos += 4;
        value.ttlType = buf[offsetPos++];
        value.ttl = EncoderUtils.readIntFromBuffer(buf, offsetPos);
        offsetPos += 4;
        value.setPermissions(buf[offsetPos++]);
        value.type = EncoderUtils.readStringByteFromBuffer(buf, offsetPos);
        value.data = EncoderUtils.readStringByteFromBuffer(buf, offsetPos += 4 + value.type.length);
        int referLength = EncoderUtils.readIntFromBuffer(buf, offsetPos += 4 + value.data.length);
        offsetPos += 4;
        value.references = new ValueReference[referLength];
        for (int i = 0; i < referLength; ++i) {
            value.references[i] = new ValueReference();
            value.references[i].handle = EncoderUtils.readStringByteFromBuffer(buf, offsetPos);
            value.references[i].index = EncoderUtils.readIntFromBuffer(buf, offsetPos += 4 + value.references[i].handle.length);
            offsetPos += 4;
        }
        return value;
    }

    public class ValueReferenceAdapter
    implements JsonSerializer<ValueReference>,
    JsonDeserializer<ValueReference> {
        public JsonElement serialize(ValueReference src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("handle", EncoderUtils.decodeString(src.handle));
            json.addProperty("index", (Number)src.index);
            return json;
        }

        public ValueReference deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonObject obj = json.getAsJsonObject();
                String handle = obj.get("handle").getAsString();
                int index = obj.get("index").getAsInt();
                return new ValueReference(handle, index);
            }
            catch (JsonParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    class ValueReference {
        public byte[] handle;
        public int index;

        public ValueReference() {
        }

        public ValueReference(byte[] handle, int index) {
            this.handle = handle;
            this.index = index;
        }

        public ValueReference(String handleString, int index) {
            this.handle = EncoderUtils.encodeString(handleString);
            this.index = index;
        }

        public String toString() {
            return EncoderUtils.decodeString(this.handle) + ":" + this.index;
        }
    }

    class HandleValueAdapter
    implements JsonSerializer<HandleValue> {
        HandleValueAdapter() {
        }

        public JsonElement serialize(HandleValue src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("index", (Number)src.index);
            json.addProperty("type", EncoderUtils.decodeString(src.type));
            json.addProperty("data", EncoderUtils.decodeString(src.data));
            json.add("permissions", src.getPermissions());
            json.add("ttl", src.getTTLAsString());
            json.addProperty("timestamp", (Number)src.timestamp);
            if (src.references != null && src.references.length > 0) {
                json.add("references", context.serialize((Object)src.references));
            }
            return json;
        }
    }

    class HandleValue {
        public static final byte TTL_TYPE_RELATIVE = 0;
        public static final byte TTL_TYPE_ABSOLUTE = 1;
        int index = -1;
        byte[] type = null;
        byte[] data = null;
        byte ttlType = 0;
        int ttl = 86400;
        int timestamp = 0;
        byte permissions = 0;
        ValueReference[] references = null;
        boolean adminRead = true;
        boolean adminWrite = true;
        boolean publicRead = true;
        boolean publicWrite = false;

        public void setPermissions(byte permissions) {
            this.permissions = permissions;
            this.adminRead = (permissions & 8) != 0;
            this.adminWrite = (permissions & 4) != 0;
            this.publicRead = (permissions & 2) != 0;
            this.publicWrite = (permissions & 1) != 0;
        }

        public final String getPermissionString() {
            return new String(new char[]{this.adminRead ? (char)'r' : '-', this.adminWrite ? (char)'w' : '-', this.publicRead ? (char)'r' : '-', this.publicWrite ? (char)'w' : '-'});
        }

        public final JsonElement getTTLAsString() {
            if (this.ttlType == 0) {
                return new JsonPrimitive((Number)this.ttl);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return new JsonPrimitive(simpleDateFormat.format(new Date(this.ttl * 1000)));
        }

        public final JsonElement getPermissions() {
            return new JsonPrimitive(this.bit(this.adminRead) + this.bit(this.adminWrite) + this.bit(this.publicRead) + this.bit(this.publicWrite));
        }

        private String bit(boolean b) {
            return b ? "1" : "0";
        }

        public String toString() {
            return " index=" + this.index + " type=" + (this.type == null ? "" : EncoderUtils.decodeString(this.type)) + " " + this.getPermissionString() + " \"" + (this.data == null ? "" : EncoderUtils.decodeString(this.data)) + '\"';
        }
    }
}

