/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpserver;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irpserver.IrpListener;
import org.bdware.irp.irpserver.IrpListenerInfo;
import org.bdware.irp.irpserver.IrpRequestHandler;
import org.bdware.irp.irpserver.NettyIrpQuicListener;
import org.bdware.irp.irpserver.NettyServerHandler;

public class NettyIrpListener
implements IrpListener {
    static Logger logger = LogManager.getLogger(NettyIrpListener.class);
    NettyServerHandler handler;
    private Channel ch;
    private final int port;
    IrpListenerInfo info;

    protected NettyIrpListener(IrpListenerInfo listenerInfo) {
        this.info = listenerInfo;
        this.port = listenerInfo.port;
    }

    public static IrpListener CreateIrpListener(IrpListenerInfo listenerInfo) {
        switch (listenerInfo.protocolType) {
            case "QUIC": 
            case "quic": {
                return new NettyIrpQuicListener(listenerInfo);
            }
        }
        return new NettyIrpListener(listenerInfo);
    }

    @Override
    public void setRequestHandler(IrpRequestHandler handler) {
        this.handler = new NettyServerHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.handler == null) {
            logger.error("Handler not init yet! set handler first");
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = this.info.workerGroupThreadSize <= 0 ? new NioEventLoopGroup() : new NioEventLoopGroup(this.info.workerGroupThreadSize);
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.port);
            b.childHandler(this.info.createChannelInitializer(this.handler));
            this.ch = b.bind().syncUninterruptibly().channel();
            logger.info("TCP DOIP listener start at:" + this.port);
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
        if (this.ch != null) {
            this.ch.close();
        }
    }
}

