/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.crypto;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.bdware.irp.irplib.crypto.AbstractPacketReceiveBuffer;
import org.bdware.irp.irplib.crypto.IrpMessagePacket;
import org.bdware.irp.irplib.exception.EnvelopeResendException;

public class NoResendPacketReceiveBuffer
extends AbstractPacketReceiveBuffer {
    HashMap<Integer, IrpMessagePacket> packetMap;
    int messageLength = 0;
    int currentLength = 0;
    TreeSet<Integer> sortedPacketNumberSet = new TreeSet();

    public NoResendPacketReceiveBuffer(int requestId, ChannelHandlerContext ctx) {
        super(requestId);
        this.packetMap = new HashMap();
    }

    @Override
    public boolean isCompleted() {
        return this.messageLength <= this.currentLength;
    }

    @Override
    public void addMessagePacket(IrpMessagePacket messagePacket) throws EnvelopeResendException {
        if (this.messageLength == 0) {
            this.messageLength = messagePacket.irpMessageEnvelope.messageLength;
        }
        this.currentLength += messagePacket.bodyPacket.length;
        this.packetMap.put(messagePacket.irpMessageEnvelope.sequenceNumber, messagePacket);
        this.sortedPacketNumberSet.add(messagePacket.irpMessageEnvelope.sequenceNumber);
    }

    @Override
    public ArrayList<IrpMessagePacket> getSortedIrpMessagePackets() {
        ArrayList<IrpMessagePacket> packets = new ArrayList<IrpMessagePacket>();
        for (int key : this.sortedPacketNumberSet) {
            packets.add(this.packetMap.get(key));
        }
        return packets;
    }
}

