/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irpclient;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp.irpclient.IrpClientChannel;
import org.bdware.irp.irpclient.IrpMessageCallback;
import org.bdware.irp.irpclient.NettyIrpClientHandler;
import org.bdware.irp.irpclient.NettyIrpQuicClientChannel;
import org.bdware.irp.irpclient.NettyIrpTCPClientChannel;
import org.bdware.irp.irplib.core.IrpMessage;

public abstract class NettyIrpClientChannel
implements IrpClientChannel {
    static Logger logger = LogManager.getLogger(NettyIrpClientChannel.class);
    protected NettyIrpClientHandler handler;
    InetSocketAddress remoteAddress;
    protected boolean isConnected = false;
    protected Channel channel;

    public static IrpClientChannel createByServerUrl(String url) {
        try {
            URI uri = new URI(url);
            logger.debug("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort());
            switch (uri.getScheme()) {
                case "udp": 
                case "UDP": 
                case "tcp": 
                case "TCP": {
                    return new NettyIrpTCPClientChannel();
                }
                case "quic": 
                case "QUIC": {
                    return new NettyIrpQuicClientChannel();
                }
            }
            logger.error("unsupported transfer scheme");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void sendMessage(IrpMessage message, IrpMessageCallback cb) {
        if (this.handler == null) {
            logger.error("client handler not set yet");
            return;
        }
        if (!this.isConnected) {
            logger.error("client not connected, connect first!");
        }
        this.handler.sendMessage(message, cb);
    }

    @Override
    public abstract void connect(String var1) throws URISyntaxException;

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }
}

