/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.exception.IrpMessageDecodeException;
import org.bdware.irp.irplib.util.EncoderUtils;

public class IrpResponse
extends IrpMessage {
    public byte[] doid;
    public byte[][] doids;
    public boolean requestDigestNeeded;
    public byte[][] doidValues = null;
    public byte[][] doidArray = null;
    public byte[] requestDigest;
    public byte[] responseMessage;
    public static final int INT_SIZE = 4;
    public String result = "success";
    public String delegateTargetURL = null;

    public IrpResponse(int opCode, int resCode) {
        super(opCode, resCode);
        this.requestDigest = null;
    }

    public IrpResponse(int opCode, int resCode, String doid) {
        super(opCode, resCode);
        if (doid != null) {
            this.doid = EncoderUtils.encodeString(doid);
        }
        this.requestDigest = null;
    }

    public static IrpResponse newIrsResolveResponse(String doid, Map<String, String> values) {
        IrpResponse res = new IrpResponse(11, 1, doid);
        res.requestDigestNeeded = false;
        if (values != null) {
            res.doidValues = IrpResponse.fromMap2Byte(values);
        }
        return res;
    }

    public static IrpResponse newIrsResolveResponse(byte[] doid, byte[][] values) {
        IrpResponse res = new IrpResponse(11, 1);
        res.doid = doid;
        res.requestDigestNeeded = false;
        res.doidValues = values;
        return res;
    }

    public static IrpResponse newIrsCreateDoidResponse(String doid) {
        IrpResponse res = new IrpResponse(110, 1, doid);
        res.requestDigestNeeded = false;
        return res;
    }

    public static IrpResponse newOrgCreateResponse(String doid) {
        IrpResponse res = new IrpResponse(213, 1, doid);
        res.requestDigestNeeded = false;
        return res;
    }

    public static IrpResponse newOrgUpdateResponse(String doid) {
        IrpResponse res = new IrpResponse(214, 1, doid);
        res.requestDigestNeeded = false;
        return res;
    }

    public static IrpResponse newOrgDeleteResponse(String doid) {
        IrpResponse res = new IrpResponse(215, 1, doid);
        res.requestDigestNeeded = false;
        return res;
    }

    public static IrpResponse newIrsCreateDoidResponse(byte[] doid) {
        IrpResponse res = new IrpResponse(110, 1);
        res.doid = doid;
        res.requestDigestNeeded = false;
        return res;
    }

    public static IrpResponse newIrsUpdateDoidResponse(String doid) {
        IrpResponse res = new IrpResponse(117, 1, doid);
        res.requestDigestNeeded = false;
        return res;
    }

    public static IrpResponse newIrsUpdateDoidResponse(byte[] doid) {
        IrpResponse res = new IrpResponse(117, 1);
        res.doid = doid;
        res.requestDigestNeeded = false;
        return res;
    }

    public static IrpResponse newIrsDeleteDoidResponse(String doid) {
        IrpResponse res = new IrpResponse(111, 1, doid);
        res.requestDigestNeeded = false;
        return res;
    }

    public static IrpResponse newIrsDeleteDoidResponse(byte[] doid) {
        IrpResponse res = new IrpResponse(111, 1);
        res.doid = doid;
        res.requestDigestNeeded = false;
        return res;
    }

    public static IrpResponse newIrsBatchCreateDoidResponse(List<String> doids) {
        IrpResponse res = new IrpResponse(120, 1);
        int length = doids.size();
        res.doids = new byte[length][];
        int i = 0;
        for (String doidEl : doids) {
            res.doids[i] = EncoderUtils.encodeString(doidEl);
            ++i;
        }
        res.requestDigestNeeded = false;
        return res;
    }

    public static IrpResponse newIrsBatchCreateDoidResponse(byte[][] doids) {
        IrpResponse res = new IrpResponse(120, 1);
        res.doids = doids;
        res.requestDigestNeeded = false;
        return res;
    }

    public static IrpResponse newUnsuccessfulResponse(int opCode, int responseCode) {
        IrpResponse res = new IrpResponse(opCode, responseCode);
        res.result = "success";
        return res;
    }

    public static IrpResponse newErrorResponse(int opCode, int responseCode, String errorMessage) {
        IrpResponse res = new IrpResponse(opCode, responseCode);
        res.requestDigestNeeded = false;
        res.responseMessage = EncoderUtils.encodeString(errorMessage);
        res.result = "failed";
        return res;
    }

    public static IrpResponse newErrorResponse(int opCode, int responseCode, byte[] errorMessage) {
        IrpResponse res = new IrpResponse(opCode, responseCode);
        res.requestDigestNeeded = false;
        res.responseMessage = errorMessage;
        res.result = "failed";
        return res;
    }

    public static IrpResponse newVerifyIrsResponse(String doid, String result) {
        IrpResponse res = new IrpResponse(211, 1, doid);
        res.requestDigestNeeded = false;
        res.responseMessage = EncoderUtils.encodeString(result);
        return res;
    }

    public static IrpResponse newVerifyIrsResponse(byte[] doid, byte[] errorMessage) {
        IrpResponse res = new IrpResponse(211, 1);
        res.requestDigestNeeded = false;
        res.doid = doid;
        res.responseMessage = errorMessage;
        return res;
    }

    public static IrpResponse newDelegateRouterResponse(String nextURL) {
        IrpResponse res = new IrpResponse(1, 303);
        res.delegateTargetURL = nextURL;
        return res;
    }

    public Map<String, String> getDoidValuesByMap() {
        Map<String, String> result = null;
        try {
            result = IrpResponse.fromBytes2Map(this.doidValues);
        }
        catch (IrpMessageDecodeException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getDoid() {
        return EncoderUtils.decodeString(this.doid);
    }

    public List<String> getDoidList() {
        ArrayList<String> doidStr = new ArrayList<String>();
        try {
            for (byte[] doidEl : this.doids) {
                doidStr.add(EncoderUtils.decodeString(doidEl));
            }
            return doidStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getResponseMessage() {
        return EncoderUtils.decodeString(this.responseMessage);
    }
}

