/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bdware.irp.irplib.core.IrpMessageBody;
import org.bdware.irp.irplib.core.IrpMessageCredential;
import org.bdware.irp.irplib.core.IrpMessageEnvelope;
import org.bdware.irp.irplib.core.IrpMessageHeader;
import org.bdware.irp.irplib.exception.IrpMessageDecodeException;
import org.bdware.irp.irplib.exception.IrpMessageEncodeException;
import org.bdware.irp.irplib.util.EncoderUtils;

public abstract class IrpMessage {
    public byte[] encodedMessageBody = null;
    public byte[] encodedCredential = null;
    public byte[] encodedMessage = null;
    public long createTime;
    public IrpMessageEnvelope envelope;
    public IrpMessageHeader header;
    public IrpMessageBody body;
    public IrpMessageCredential credential;

    public IrpMessage(int opCode) {
        this.envelope = new IrpMessageEnvelope();
        this.header = new IrpMessageHeader(opCode);
        this.body = new IrpMessageBody();
        this.credential = new IrpMessageCredential();
        this.createTime = System.currentTimeMillis();
    }

    public IrpMessage(int opCode, int responseCode) {
        this.envelope = new IrpMessageEnvelope();
        this.header = new IrpMessageHeader(opCode, responseCode);
        this.body = new IrpMessageBody();
        this.credential = new IrpMessageCredential();
        this.createTime = System.currentTimeMillis();
    }

    public IrpMessage(int opCode, int responseCode, int requestId) {
        this.envelope = new IrpMessageEnvelope(requestId);
        this.header = new IrpMessageHeader(opCode, responseCode);
        this.body = new IrpMessageBody();
        this.credential = new IrpMessageCredential();
        this.createTime = System.currentTimeMillis();
    }

    public final String getSignature() {
        if (this.credential.signature != null) {
            return EncoderUtils.decodeString(this.credential.signature);
        }
        return null;
    }

    public final byte[] getEncodedMessageHeaderBody() throws IrpMessageEncodeException {
        if (this.encodedMessageBody != null) {
            return this.encodedMessageBody;
        }
        this.encodedMessageBody = EncoderUtils.encodeMessageBody(this);
        return this.encodedMessageBody;
    }

    public final byte[] getEncodeMessageCredential() throws IrpMessageEncodeException {
        if (this.encodedCredential != null) {
            return this.encodedCredential;
        }
        if (this.header.getCertifiedFlag()) {
            this.encodedCredential = EncoderUtils.encodeMessageCredential(this.credential);
        } else {
            this.encodedCredential = new byte[4];
            EncoderUtils.writeIntToBuffer(0, this.encodedCredential, 0);
        }
        return this.encodedCredential;
    }

    public final byte[] getEncodedMessage() throws IrpMessageEncodeException {
        if (this.encodedMessage != null) {
            return this.encodedMessage;
        }
        this.getEncodedMessageHeaderBody();
        this.getEncodeMessageCredential();
        this.encodedMessage = new byte[this.encodedMessageBody.length + this.encodedCredential.length];
        System.arraycopy(this.encodedMessageBody, 0, this.encodedMessage, 0, this.encodedMessageBody.length);
        System.arraycopy(this.encodedCredential, 0, this.encodedMessage, this.encodedMessageBody.length, this.encodedCredential.length);
        return this.encodedMessage;
    }

    public static byte[][] fromJson2Byte(JsonObject hashMap) {
        byte[][] bytes = new byte[hashMap.size()][];
        int index = 0;
        for (String key : hashMap.keySet()) {
            byte[] keyCode = EncoderUtils.encodeString(key);
            JsonElement je = hashMap.get(key);
            byte[] valueCode = EncoderUtils.encodeString(je.toString());
            byte[] entryCode = new byte[4 + keyCode.length + 4 + valueCode.length];
            int offset = EncoderUtils.writeStringByteToBuffer(keyCode, entryCode, 0);
            EncoderUtils.writeStringByteToBuffer(valueCode, entryCode, offset);
            bytes[index] = entryCode;
            ++index;
        }
        return bytes;
    }

    public static JsonObject fromByte2Json(byte[][] buf) throws IrpMessageDecodeException {
        JsonObject doidValue = new JsonObject();
        for (byte[] sigBuf : buf) {
            byte[] keyCode = EncoderUtils.readStringByteFromBuffer(sigBuf, 0);
            int offsetPos = 4 + keyCode.length;
            byte[] valueCode = EncoderUtils.readStringByteFromBuffer(sigBuf, offsetPos);
            String content = EncoderUtils.decodeString(valueCode);
            JsonElement jsonElement = null;
            try {
                jsonElement = JsonParser.parseString((String)content);
            }
            catch (Exception e) {
                jsonElement = new JsonPrimitive(content);
            }
            doidValue.add(EncoderUtils.decodeString(keyCode), jsonElement);
        }
        return doidValue;
    }

    public static byte[][] fromMap2ByteDeprecated(Map<String, String> hashMap) {
        byte[][] bytes = new byte[hashMap.size()][];
        int index = 0;
        for (String key : hashMap.keySet()) {
            byte[] keyCode = EncoderUtils.encodeString(key);
            byte[] valueCode = EncoderUtils.encodeString(String.valueOf(hashMap.get(key)));
            byte[] entryCode = new byte[4 + keyCode.length + 4 + valueCode.length];
            int offset = EncoderUtils.writeStringByteToBuffer(keyCode, entryCode, 0);
            EncoderUtils.writeStringByteToBuffer(valueCode, entryCode, offset);
            bytes[index] = entryCode;
            ++index;
        }
        return bytes;
    }

    public static Map<String, String> fromMap2ByteDeprecated(byte[][] buf) throws IrpMessageDecodeException {
        HashMap<String, String> doidValue = new HashMap<String, String>();
        for (byte[] sigBuf : buf) {
            byte[] keyCode = EncoderUtils.readStringByteFromBuffer(sigBuf, 0);
            int offsetPos = 4 + keyCode.length;
            byte[] valueCode = EncoderUtils.readStringByteFromBuffer(sigBuf, offsetPos);
            doidValue.put(EncoderUtils.decodeString(keyCode), EncoderUtils.decodeString(valueCode));
        }
        return doidValue;
    }

    public String toString() {
        String str = "version=" + this.envelope.majorVersion + '.' + this.envelope.minVersion + "; opCode=" + this.header.opCode + "; responseCode=" + this.header.responseCode + "; opFlag" + this.header.getOpFlagByFlags() + "; bodyLength" + this.header.bodyLength + "; createTime:" + new Date(this.createTime);
        return str;
    }

    public abstract String getDoid();
}

