/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec.predefined;

import com.nimbusds.jose.JWSObject;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import org.bdware.irp3.codec.Element;

public class HS_Cert
extends Element {
    public static String TYPE = "HS_CERT";
    private JWSObject jsonWebSignature;

    public HS_Cert(Element element) {
        super(element);
        assert (element.getType().equals(TYPE));
    }

    public HS_Cert() {
        this.setType(TYPE);
    }

    @Override
    public void fillFieldsFromValue() {
        try {
            this.jsonWebSignature = JWSObject.parse((String)new String(this.getValue(), StandardCharsets.UTF_8));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] calculateValue() {
        return this.jsonWebSignature.serialize().getBytes(StandardCharsets.UTF_8);
    }

    public JWSObject getJsonWebSignature() {
        return this.jsonWebSignature;
    }

    public void setJsonWebSignature(JWSObject jsonWebSignature) {
        this.jsonWebSignature = jsonWebSignature;
    }
}

