/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec.predefined;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import org.bdware.irp3.codec.Element;
import org.bdware.irp3.codec.UTF8String;
import org.bdware.irp3.codec.predefined.Attribute;
import org.bdware.irp3.codec.predefined.ServerRecord;

public class HS_Site
extends Element {
    private short version;
    private short protocolVersion;
    private short serialNumber;
    private byte primaryMask;
    private byte hashOption;
    private String hashFilter;
    private Attribute[] attributes;
    private int numOfServer;
    private ServerRecord[] serverRecords;
    public static String TYPE = "HS_SITE";

    public HS_Site(Element element) {
        super(element);
        assert (element.getType().equals(TYPE));
    }

    public HS_Site() {
        this.setType(TYPE);
    }

    @Override
    public void fillFieldsFromValue() {
        ByteBuf toRead = Unpooled.wrappedBuffer((byte[])this.getValue());
        this.version = toRead.readShort();
        this.protocolVersion = toRead.readShort();
        this.serialNumber = toRead.readShort();
        this.primaryMask = toRead.readByte();
        this.hashOption = toRead.readByte();
        this.hashFilter = UTF8String.fromByteBuf(toRead);
        this.attributes = Attribute.listFromByteBuf(toRead);
        this.numOfServer = toRead.readInt();
        this.serverRecords = ServerRecord.listFromByteBuf(toRead);
        this.setType(TYPE);
    }

    @Override
    public byte[] calculateValue() {
        ByteBuf buf = Unpooled.directBuffer();
        buf.writeShort((int)this.version);
        buf.writeShort((int)this.protocolVersion);
        buf.writeShort((int)this.serialNumber);
        buf.writeByte((int)this.primaryMask);
        buf.writeByte((int)this.hashOption);
        UTF8String.toByteBuf(this.hashFilter, buf);
        Attribute.toByteBuf(this.attributes, buf);
        buf.writeInt(this.numOfServer);
        ServerRecord.toByteBuf(this.serverRecords, buf);
        byte[] value = ByteBufUtil.getBytes((ByteBuf)buf);
        return value;
    }

    public short getVersion() {
        return this.version;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(short protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public short getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(short serialNumber) {
        this.serialNumber = serialNumber;
    }

    public byte getPrimaryMask() {
        return this.primaryMask;
    }

    public void setPrimaryMask(byte primaryMask) {
        this.primaryMask = primaryMask;
    }

    public byte getHashOption() {
        return this.hashOption;
    }

    public void setHashOption(byte hashOption) {
        this.hashOption = hashOption;
    }

    public String getHashFilter() {
        return this.hashFilter;
    }

    public void setHashFilter(String hashFilter) {
        this.hashFilter = hashFilter;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
    }

    public int getNumOfServer() {
        return this.numOfServer;
    }

    public void setNumOfServer(int numOfServer) {
        this.numOfServer = numOfServer;
    }

    public ServerRecord[] getServerRecords() {
        return this.serverRecords;
    }

    public void setServerRecords(ServerRecord[] serverRecords) {
        this.serverRecords = serverRecords;
    }

    public static class Prefix
    extends HS_Site {
        public static String PREFIX_TYPE = "HS_SITE.PREFIX";

        public Prefix(Element element) {
            this.setIndex(element.getIndex());
            this.setType(element.getType());
            this.setValue(element.getValue());
            this.setPermission(element.getPermission());
            this.setTtlType(element.getTtlType());
            this.setTtl(element.getTtl());
            this.setTimestamp(element.getTimestamp());
            this.fillFieldsFromValue();
            this.setType(PREFIX_TYPE);
        }

        public Prefix() {
            this.setType(PREFIX_TYPE);
        }
    }
}

