package org.bdware.irp3.codec.predefined;

import org.bdware.irp3.codec.Element;
import org.bdware.irp3.codec.UTF8String;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

import java.nio.charset.StandardCharsets;

public class HS_Serv extends Element {
    public static class Prefix extends HS_Serv {
        public static String PREFIX_TYPE = "HS_SERV.PREFIX";
        private String serviceIdentifier;
        
        public Prefix(Element element) {
            super(element);
            if (element != null && !element.getType().equals(PREFIX_TYPE)) {
                throw new IllegalArgumentException("Invalid type: " + element.getType() + ", expected: " + PREFIX_TYPE);
            }
            setType(PREFIX_TYPE);
        }

        public Prefix() {
            setType(PREFIX_TYPE);
        }
        @Override
        public void fillFieldsFromValue() {
            if (getValue() == null || getValue().length == 0) {
                throw new RuntimeException("value is null or empty");
            }
            ByteBuf toRead = Unpooled.wrappedBuffer(this.getValue());
            
            serviceIdentifier = UTF8String.fromByteBuf(toRead);

            validate();
        }
        
        @Override
        public byte[] calculateValue() {
            validate();
            
            if (serviceIdentifier == null) {
                throw new RuntimeException("service identifier is null");
            }
            
            ByteBuf toWrite = Unpooled.buffer();
            UTF8String.toByteBuf(serviceIdentifier, toWrite);
            byte[] result = new byte[toWrite.readableBytes()];
            toWrite.readBytes(result);
            toWrite.release();
            return result;
        }
    }

    public static String TYPE = "HS_SERV";
    private String serviceIdentifier;

    public HS_Serv(Element element) {
        super(element);
        if (element != null && !element.getType().equals(TYPE)) {
            throw new IllegalArgumentException("Invalid type: " + element.getType() + ", expected: " + TYPE);
        }
    }

    public HS_Serv() {
        setType(TYPE);
    }
    
    public HS_Serv(String serviceIdentifier) {
        setType(TYPE);
        setServIdentifier(serviceIdentifier);
    }

    public void validate() {
        if (serviceIdentifier == null || serviceIdentifier.isEmpty()) {
            throw new RuntimeException("service identifier cannot be empty");
        }
    }

    public void setServIdentifier(String identifier) {
        this.serviceIdentifier = identifier;
        if (identifier != null) {
            setValue(identifier.getBytes(StandardCharsets.UTF_8));
        }
    }

    public String getServIdentifier() {
        return serviceIdentifier;
    }

    @Override
    public void fillFieldsFromValue() {
        if (getValue() == null || getValue().length == 0) {
            throw new RuntimeException("value is null or empty");
        }
        
        ByteBuf toRead = Unpooled.wrappedBuffer(this.getValue());
        serviceIdentifier = UTF8String.fromByteBuf(toRead);

        validate();
    }

    @Override
    public byte[] calculateValue() {
        validate();
        
        if (serviceIdentifier == null) {
            throw new RuntimeException("service identifier is null");
        }
        
        ByteBuf toWrite = Unpooled.buffer();
        UTF8String.toByteBuf(serviceIdentifier, toWrite);
        byte[] result = new byte[toWrite.readableBytes()];
        toWrite.readBytes(result);
        toWrite.release();
        return result;
    }
}
