/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.deprecated;

import com.nimbusds.jose.jwk.JWK;
import org.bdware.irp.deprecated.GlobalUtils;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpMessageSigner;
import org.bdware.irp.irplib.util.EncoderUtils;
import org.bdware.irp.irplib.util.IrpCommon;

public class JWKSigner
implements IrpMessageSigner {
    JWK jwk;

    public JWKSigner(JWK jwk) {
        this.jwk = jwk;
    }

    @Override
    public final boolean verifyMessage(IrpMessage irpMessage) {
        try {
            byte[] digestData = irpMessage.getEncodedMessageHeaderBody();
            String signature = EncoderUtils.decodeString(irpMessage.credential.signature);
            String pubkey = EncoderUtils.decodeString(irpMessage.credential.signerDoid);
            return GlobalUtils.verifySigByJWK(digestData, signature, pubkey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final void signMessage(IrpMessage irpMessage, JWK jwk) {
        try {
            if (jwk == null) {
                return;
            }
            irpMessage.header.setCertifiedFlag(true);
            byte[] digestData = irpMessage.getEncodedMessageHeaderBody();
            String signature = GlobalUtils.signByteArrayByJWK(digestData, jwk);
            irpMessage.credential.signerDoid = EncoderUtils.encodeString(jwk.getKeyID());
            irpMessage.credential.signedInfoType = IrpCommon.CREDENTIAL_SIGNEDINFO_TYPE_JWK;
            irpMessage.credential.signedInfoDigestAlgorithm = IrpCommon.CREDENTIAL_DIGEST_ALG_JWK;
            irpMessage.credential.signature = EncoderUtils.encodeString(signature);
            irpMessage.credential.signedInfoLength = irpMessage.credential.signedInfoDigestAlgorithm.length + irpMessage.credential.signature.length;
            irpMessage.encodedMessage = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void signMessage(IrpMessage irpMessage) {
        JWKSigner.signMessage(irpMessage, this.jwk);
    }
}

