/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp.irplib.core;

import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import org.bdware.irp.irplib.core.IrpMessage;
import org.bdware.irp.irplib.core.IrpMessageSigner;
import org.bdware.irp.irplib.core.IrpRequest;
import org.bdware.irp.irplib.util.EncoderUtils;

public class IrpRequestFactory {
    public static final String DOID_DEFAULT = "doidForCreate";
    public IrpMessageSigner signer;

    public IrpRequestFactory(IrpMessageSigner signer) {
        this.signer = signer;
    }

    public IrpRequest newIrsResolveRequest(String doid, String[] keys) {
        IrpRequest req = new IrpRequest(11, doid);
        if (keys != null) {
            req.requestedKeys = new byte[keys.length][];
            for (int i = 0; i < keys.length; ++i) {
                req.requestedKeys[i] = EncoderUtils.encodeString(keys[i]);
            }
        }
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsResolveRecursiveRequest(String doid, String[] keys) {
        IrpRequest req = new IrpRequest(121, doid);
        if (keys != null) {
            req.requestedKeys = new byte[keys.length][];
            for (int i = 0; i < keys.length; ++i) {
                req.requestedKeys[i] = EncoderUtils.encodeString(keys[i]);
            }
        }
        JsonObject values = new JsonObject();
        values.addProperty("recursiveFlag", "true");
        req.doidValues = IrpMessage.fromJson2Byte(values);
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newGrsResolveRequest(String doid, String[] keys) {
        IrpRequest req = new IrpRequest(212, doid);
        if (keys != null) {
            req.requestedKeys = new byte[keys.length][];
            for (int i = 0; i < keys.length; ++i) {
                req.requestedKeys[i] = EncoderUtils.encodeString(keys[i]);
            }
        }
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newGrsCreateOrgRequest(String doi, JsonObject values) {
        IrpRequest req = new IrpRequest(213, doi);
        if (values != null) {
            req.doidValues = IrpMessage.fromJson2Byte(values);
        }
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsSynOrgToParentRequest(String doi, JsonObject values) {
        IrpRequest req = new IrpRequest(213, doi);
        if (values != null) {
            req.doidValues = IrpMessage.fromJson2Byte(values);
        }
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsResolveRequest(byte[] doid, byte[][] keys, byte[][] doidValues) {
        IrpRequest req = new IrpRequest(11, doid);
        req.requestedKeys = keys;
        req.doidValues = doidValues;
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsResolveRequest(byte[] doid, byte[][] keys) {
        IrpRequest req = new IrpRequest(11, doid);
        req.requestedKeys = keys;
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsCreateDoidRequest(JsonObject values) {
        return this.newIrsCreateDoidRequest(DOID_DEFAULT, values);
    }

    public IrpRequest newIrsCreateDoidRequest(String doid, JsonObject values) {
        if (doid == null) {
            doid = DOID_DEFAULT;
        }
        IrpRequest req = new IrpRequest(110, doid);
        if (values != null) {
            req.doidValues = IrpMessage.fromJson2Byte(values);
        }
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsCreateDoidRequest(byte[] doid, byte[][] values) {
        if (doid == null) {
            doid = DOID_DEFAULT.getBytes(StandardCharsets.UTF_8);
        }
        IrpRequest req = new IrpRequest(110, doid);
        req.doidValues = values;
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsUpdateDoidRequest(String doid, JsonObject values) {
        IrpRequest req = new IrpRequest(117, doid);
        if (values != null) {
            req.doidValues = IrpMessage.fromJson2Byte(values);
        }
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsUpdateDoidRequest(byte[] doid, byte[][] values) {
        IrpRequest req = new IrpRequest(117, doid);
        req.doidValues = values;
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsDeleteDoidRequest(String doid) {
        IrpRequest req = new IrpRequest(111, doid);
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsDeleteDoidRequest(byte[] doid) {
        IrpRequest req = new IrpRequest(111, doid);
        return req;
    }

    public IrpRequest newIrsBatchCreateDoidRequest(JsonObject values, int count) {
        IrpRequest req = new IrpRequest(120, DOID_DEFAULT);
        if (values != null) {
            req.doidValues = IrpMessage.fromJson2Byte(values);
        }
        req.createNumber = count;
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newIrsBatchCreateDoidRequest(int count, byte[][] values) {
        IrpRequest req = new IrpRequest(120, DOID_DEFAULT);
        req.doidValues = values;
        req.createNumber = count;
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newVerityIrsServerRequest(String doid, String address) {
        IrpRequest req = new IrpRequest(211, doid);
        req.address = EncoderUtils.encodeString(address);
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newVerityIrsServerRequest(byte[] doid, byte[] address) {
        IrpRequest req = new IrpRequest(211, doid);
        req.address = address;
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newQueryRouterInfo() {
        IrpRequest req = new IrpRequest(802, DOID_DEFAULT);
        JsonObject values = new JsonObject();
        values.addProperty("routerInfo", "true");
        req.doidValues = IrpMessage.fromJson2Byte(values);
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }

    public IrpRequest newQueryDOByOffsetRequest(int offset, int count, boolean queryByCreateTime) {
        IrpRequest req = new IrpRequest(802, DOID_DEFAULT);
        JsonObject values = new JsonObject();
        values.addProperty("offset", offset + "");
        values.addProperty("count", count + "");
        if (queryByCreateTime) {
            values.addProperty("queryByCreateTime", "true");
        }
        req.doidValues = IrpMessage.fromJson2Byte(values);
        if (this.signer != null) {
            this.signer.signMessage(req);
        }
        return req;
    }
}

