/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.client;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.client.ResultCallback;
import org.bdware.irp3.client.TimoutMessageFactory;
import org.bdware.irp3.codec.Message;

public class ResponseWait<T extends Message> {
    static Logger LOGGER = LogManager.getLogger(ResponseWait.class);
    public static final HashedWheelTimer HASHED_WHEEL_TIMER = new HashedWheelTimer(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }, 5L, TimeUnit.MILLISECONDS, 2);
    final Map<Integer, ResultCallback<T>> waitObj = new ConcurrentHashMap<Integer, ResultCallback<T>>();
    private final TimoutMessageFactory<T> factory;

    public ResponseWait(TimoutMessageFactory<T> factory) {
        this.factory = factory;
    }

    public void wakeUpAndRemove(int requestID, T result) {
        ResultCallback<T> ob = this.getAndRemove(requestID);
        this.wakeup(requestID, ob, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultCallback<T> getAndRemove(int requestID) {
        Map<Integer, ResultCallback<T>> map = this.waitObj;
        synchronized (map) {
            ResultCallback<T> ob = this.waitObj.get(requestID);
            this.waitObj.remove(requestID);
            return ob;
        }
    }

    public boolean waitResponse(int requestID, ResultCallback<T> cb) {
        return this.waitResponse(requestID, cb, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitResponse(final int requestID, ResultCallback<T> cb, int seconds) {
        if (this.waitObj.size() > 1000) {
            return false;
        }
        Map<Integer, ResultCallback<T>> map = this.waitObj;
        synchronized (map) {
            if (!this.waitObj.containsKey(requestID)) {
                this.waitObj.put(requestID, cb);
                TimerTask tt = new TimerTask(){

                    public void run(Timeout timeout) throws Exception {
                        Object timeOutMessage = ResponseWait.this.factory.creatTimeOutResponse(requestID);
                        ResponseWait.this.wakeUpAndRemove(requestID, timeOutMessage);
                    }
                };
                HASHED_WHEEL_TIMER.newTimeout(tt, (long)seconds, TimeUnit.SECONDS);
                return true;
            }
            LOGGER.info("Return false, try again!");
            return false;
        }
    }

    public void wakeup(int requestID, T result) {
        ResultCallback<T> ob = this.waitObj.get(requestID);
        this.wakeup(requestID, ob, result);
    }

    public void wakeup(int requestID, ResultCallback<T> ob, T result) {
        if (ob == null) {
            // empty if block
        }
        if (ob != null) {
            ob.onResult(result);
        }
    }
}

