/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.Opcode;
import org.bdware.irp3.body.AddElementRequest;
import org.bdware.irp3.body.ChallengeResponseRequest;
import org.bdware.irp3.body.CreateIdentifierRequest;
import org.bdware.irp3.body.DeleteIdentifierRequest;
import org.bdware.irp3.body.GeneralMessage;
import org.bdware.irp3.body.GetSiteInfoRequest;
import org.bdware.irp3.body.HomePrefixRequest;
import org.bdware.irp3.body.ListDerivedPrefixsRequest;
import org.bdware.irp3.body.ListHomedPrefixRequest;
import org.bdware.irp3.body.ListIdentifiersRequest;
import org.bdware.irp3.body.ModifyElementRequest;
import org.bdware.irp3.body.QueryRequest;
import org.bdware.irp3.body.RemoveElementRequest;
import org.bdware.irp3.body.SessionSetupRequest;
import org.bdware.irp3.body.SessionTerminationRequest;
import org.bdware.irp3.body.UnhomePrefixRequest;
import org.bdware.irp3.body.VerificationRequest;
import org.bdware.irp3.codec.IrpMessage;
import org.bdware.irp3.codec.MessageBody;
import org.bdware.irp3.codec.MessageHeader;
import org.bdware.irp3.codec.ResponseCodec;

public class RequestCodec
extends MessageToMessageCodec<IrpMessage, MessageBody> {
    static Logger LOGGER = LogManager.getLogger(ResponseCodec.class);

    protected void encode(ChannelHandlerContext ctx, MessageBody msg, List<Object> out) throws Exception {
        IrpMessage message = msg.wrapHeader();
        out.add(message);
        LOGGER.info("SEND:" + msg.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, IrpMessage msg, List<Object> out) throws Exception {
        try {
            MessageHeader header = msg.header;
            Opcode opcode = Opcode.fromInt(header.opCode);
            ByteBuf byteBuf = msg.body.toRead;
            if (opcode == null) {
                out.add(GeneralMessage.fromByteBuf(byteBuf));
            }
            switch (opcode) {
                case OC_RESOLUTION: {
                    out.add(QueryRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_GET_SITE_INFO: {
                    out.add(GetSiteInfoRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_CREATE_ID: {
                    out.add(CreateIdentifierRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_DELETE_ID: {
                    out.add(DeleteIdentifierRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_ADD_ELEMENT: {
                    out.add(AddElementRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_REMOVE_ELEMENT: {
                    out.add(RemoveElementRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_MODIFY_ELEMENT: {
                    out.add(ModifyElementRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_HOME_PREFIX: {
                    out.add(HomePrefixRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_UNHOME_PREFIX: {
                    out.add(UnhomePrefixRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_LIST_IDS: {
                    out.add(ListIdentifiersRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_LIST_DERIVED_PREFIXES: {
                    out.add(ListDerivedPrefixsRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_LIST_HOMED_PREFIXES: {
                    out.add(ListHomedPrefixRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_CHALLENGE_RESPONSE: {
                    out.add(ChallengeResponseRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_VERIFY_RESPONSE: {
                    out.add(VerificationRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_SESSION_SETUP: {
                    out.add(SessionSetupRequest.fromByteBuf(byteBuf));
                    return;
                }
                case OC_SESSION_TERMINATE: {
                    out.add(SessionTerminationRequest.fromByteBuf(byteBuf));
                    return;
                }
            }
            out.add(GeneralMessage.fromByteBuf(byteBuf));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out.size() > 0) {
                LOGGER.info("RECV:" + out.get(0).toString());
                ((MessageBody)out.get(0)).setRequestID(msg.envelope.requestId);
                ((MessageBody)out.get(0)).setSender(msg.getSender());
            }
            if (msg != null && msg.body != null && msg.body.toRead != null) {
                msg.body.toRead.release();
            }
        }
    }
}

