/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec.predefined;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.bdware.irp3.codec.ByteList;
import org.bdware.irp3.codec.Element;
import org.bdware.irp3.codec.UTF8String;

public class HS_Pubkey
extends Element {
    public static String TYPE = "HS_PUBKEY";
    String keyType;
    short reserved;
    List<byte[]> publicKeyData;

    public HS_Pubkey(Element element) {
        super(element);
        assert (element.getType().equals(TYPE));
    }

    public HS_Pubkey() {
        this.setType(TYPE);
    }

    @Override
    public void fillFieldsFromValue() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.getValue());
        this.keyType = UTF8String.fromByteBuf(byteBuf);
        this.reserved = byteBuf.readShort();
        this.publicKeyData = new ArrayList<byte[]>();
        while (byteBuf.isReadable()) {
            byte[] data = ByteList.fromByteBuf(byteBuf);
            this.publicKeyData.add(data);
        }
        this.validate();
    }

    @Override
    public byte[] calculateValue() {
        this.validate();
        ByteBuf byteBuf = Unpooled.directBuffer();
        UTF8String.toByteBuf(this.keyType, byteBuf);
        byteBuf.writeShort((int)this.reserved);
        for (byte[] data : this.publicKeyData) {
            ByteList.toByteBuf(data, byteBuf);
        }
        return ByteBufUtil.getBytes((ByteBuf)byteBuf);
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public short getReserved() {
        return this.reserved;
    }

    public void setReserved(short reserved) {
        this.reserved = reserved;
    }

    public List<byte[]> getPublicKeyData() {
        return this.publicKeyData;
    }

    public void setPublicKeyData(List<byte[]> publicKeyData) {
        this.publicKeyData = publicKeyData;
    }

    public void validate() {
        if (this.keyType == null || this.keyType.isEmpty()) {
            throw new IllegalArgumentException("Key type cannot be empty");
        }
        if (this.publicKeyData == null) {
            throw new IllegalArgumentException("Public key data cannot be null");
        }
        switch (this.keyType) {
            case "DSA_PUB_KEY": {
                if (this.publicKeyData.size() != 4) {
                    throw new IllegalArgumentException(String.format("DSA_PUB_KEY requires exactly 4 byte arrays (q, p, g, y), got %d", this.publicKeyData.size()));
                }
                for (int i = 0; i < this.publicKeyData.size(); ++i) {
                    if (this.publicKeyData.get(i) != null && this.publicKeyData.get(i).length != 0) continue;
                    throw new IllegalArgumentException(String.format("DSA parameter %d cannot be empty", i));
                }
                break;
            }
            case "RSA_PUB_KEY": {
                if (this.publicKeyData.size() != 4) {
                    throw new IllegalArgumentException(String.format("RSA_PUB_KEY requires exactly 4 byte arrays (exponent, modulus, empty, empty), got %d", this.publicKeyData.size()));
                }
                if (this.publicKeyData.get(0) == null || this.publicKeyData.get(0).length == 0) {
                    throw new IllegalArgumentException("RSA exponent cannot be empty");
                }
                if (this.publicKeyData.get(1) == null || this.publicKeyData.get(1).length == 0) {
                    throw new IllegalArgumentException("RSA modulus cannot be empty");
                }
                if (this.publicKeyData.get(2) == null || this.publicKeyData.get(2).length != 0) {
                    throw new IllegalArgumentException(String.format("RSA third byte array must be empty, got length %d", this.publicKeyData.get(2) != null ? this.publicKeyData.get(2).length : -1));
                }
                if (this.publicKeyData.get(3) != null && this.publicKeyData.get(3).length == 0) break;
                throw new IllegalArgumentException(String.format("RSA fourth byte array must be empty, got length %d", this.publicKeyData.get(3) != null ? this.publicKeyData.get(3).length : -1));
            }
            default: {
                throw new IllegalArgumentException("Unsupported key type: " + this.keyType);
            }
        }
    }
}

