/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.codec.predefined;

import io.netty.buffer.ByteBuf;
import org.bdware.irp3.codec.ByteList;
import org.bdware.irp3.codec.predefined.ServiceInterface;

public class ServerRecord {
    int serverID;
    byte[] address;
    byte[] publicKeyRecord;
    ServiceInterface[] serviceInterfaces;

    public static ServerRecord fromByteBuf(ByteBuf byteBuf) {
        ServerRecord record = new ServerRecord();
        record.serverID = byteBuf.readInt();
        record.address = new byte[16];
        byteBuf.readBytes(record.address);
        record.publicKeyRecord = ByteList.fromByteBuf(byteBuf);
        record.serviceInterfaces = ServiceInterface.listFromByteBuf(byteBuf);
        return record;
    }

    public static ServerRecord[] listFromByteBuf(ByteBuf byteBuf) {
        int len = byteBuf.readInt();
        if (len <= 0) {
            len = 0;
        }
        ServerRecord[] ret = new ServerRecord[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = ServerRecord.fromByteBuf(byteBuf);
        }
        return ret;
    }

    public void toByteBuf(ByteBuf byteBuf) {
        byteBuf.writeInt(this.serverID);
        if (this.address == null || this.address.length != 16) {
            throw new IllegalStateException("Address must be exactly 16 bytes for IPv6");
        }
        byteBuf.writeBytes(this.address);
        ByteList.toByteBuf(this.publicKeyRecord, byteBuf);
        ServiceInterface.toByteBuf(this.serviceInterfaces, byteBuf);
    }

    public static void toByteBuf(ServerRecord[] serverRecords, ByteBuf byteBuf) {
        if (serverRecords == null || serverRecords.length == 0) {
            byteBuf.writeInt(0);
            return;
        }
        byteBuf.writeInt(serverRecords.length);
        for (int i = 0; i < serverRecords.length; ++i) {
            serverRecords[i].toByteBuf(byteBuf);
        }
    }
}

